/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.output.TeeOutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.util.StringUtils;

public class BHiveTeeHttpOutputMessage
implements HttpOutputMessage {
    HttpOutputMessage httpOutputMessage;
    OutputStream customBodyStream;
    ByteArrayOutputStream baos;

    public BHiveTeeHttpOutputMessage(HttpOutputMessage httpOutputMessage) throws IOException {
        this.httpOutputMessage = httpOutputMessage;
        this.baos = new ByteArrayOutputStream();
        this.customBodyStream = new TeeOutputStream(httpOutputMessage.getBody(), (OutputStream)this.baos);
    }

    public HttpHeaders getHeaders() {
        return this.httpOutputMessage.getHeaders();
    }

    public OutputStream getBody() throws IOException {
        return this.customBodyStream;
    }

    public byte[] getTeeOutputBytes() {
        return this.baos.toByteArray();
    }

    public String getTeeOutputString() throws UnsupportedEncodingException {
        return StringUtils.trimTrailingWhitespace((String)this.baos.toString("UTF-8"));
    }
}

