/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.jooq.Attachable;
import org.jooq.AttachableInternal;
import org.jooq.BindContext;
import org.jooq.Condition;
import org.jooq.ConditionProvider;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Cursor;
import org.jooq.DataType;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Results;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.SchemaMapping;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.conf.BackslashEscaping;
import org.jooq.conf.ParamType;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.TooManyRowsException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.DropStatementType;
import org.jooq.impl.Fields;
import org.jooq.impl.Identifiers;
import org.jooq.impl.Intern;
import org.jooq.impl.MetaDataFieldProvider;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.RecordFactory;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Val;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.reflect.Reflect;

final class Utils {
    static final JooqLogger log = JooqLogger.getLogger(Utils.class);
    static final String DATA_REFLECTION_CACHE_GET_ANNOTATED_GETTER = new String("org.jooq.configuration.reflection-cache.get-annotated-getter");
    static final String DATA_REFLECTION_CACHE_GET_ANNOTATED_MEMBERS = new String("org.jooq.configuration.reflection-cache.get-annotated-members");
    static final String DATA_REFLECTION_CACHE_GET_ANNOTATED_SETTERS = new String("org.jooq.configuration.reflection-cache.get-annotated-setters");
    static final String DATA_REFLECTION_CACHE_GET_MATCHING_GETTER = new String("org.jooq.configuration.reflection-cache.get-matching-getter");
    static final String DATA_REFLECTION_CACHE_GET_MATCHING_MEMBERS = new String("org.jooq.configuration.reflection-cache.get-matching-members");
    static final String DATA_REFLECTION_CACHE_GET_MATCHING_SETTERS = new String("org.jooq.configuration.reflection-cache.get-matching-setters");
    static final String DATA_REFLECTION_CACHE_HAS_COLUMN_ANNOTATIONS = new String("org.jooq.configuration.reflection-cache.has-column-annotations");
    static final char ESCAPE = '!';
    private static Boolean isJPAAvailable;
    private static int maxConsumedExceptions;
    private static int maxConsumedResults;
    private static final Pattern DASH_PATTERN;
    private static final Pattern PLUS_PATTERN;
    private static final String WHITESPACE = " \t\n\u000b\f\r";
    private static final String[] JDBC_ESCAPE_PREFIXES;

    Utils() {
    }

    static final List<Row> rows(Result<?> result) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Record record : result) {
            rows.add(record.valuesRow());
        }
        return rows;
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Class<R> type) {
        return Utils.newRecord(fetched, type, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Class<R> type, Field<?>[] fields) {
        return Utils.newRecord(fetched, type, fields, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Table<R> type) {
        return Utils.newRecord(fetched, type, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Table<R> type, Configuration configuration) {
        return Utils.newRecord(fetched, type.getRecordType(), type.fields(), configuration);
    }

    static final <R extends UDTRecord<R>> RecordDelegate<R> newRecord(boolean fetched, UDT<R> type) {
        return Utils.newRecord(fetched, type, null);
    }

    static final <R extends UDTRecord<R>> RecordDelegate<R> newRecord(boolean fetched, UDT<R> type, Configuration configuration) {
        return Utils.newRecord(fetched, type.getRecordType(), type.fields(), configuration);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, Class<R> type, Field<?>[] fields, Configuration configuration) {
        return Utils.newRecord(fetched, Utils.recordFactory(type, fields), configuration);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(boolean fetched, RecordFactory<R> factory, Configuration configuration) {
        try {
            R record = factory.newInstance();
            if (record instanceof AbstractRecord) {
                ((AbstractRecord)record).fetched = fetched;
            }
            return new RecordDelegate<R>(configuration, record);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new record", e);
        }
    }

    static final <R extends Record> RecordFactory<R> recordFactory(Class<R> type, Field<?>[] fields) {
        if (type == RecordImpl.class || type == Record.class) {
            final RowImpl row = new RowImpl(fields);
            return new RecordFactory<R>(){

                @Override
                public R newInstance() {
                    return new RecordImpl(row);
                }
            };
        }
        try {
            final Constructor<R> constructor = Reflect.accessible(type.getDeclaredConstructor(new Class[0]));
            return new RecordFactory<R>(){

                @Override
                public R newInstance() {
                    try {
                        return (Record)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Could not construct new record", e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new record", e);
        }
    }

    static void resetChangedOnNotNull(Record record) {
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            if (record.getValue(i) != null || record.field(i).getDataType().nullable()) continue;
            record.changed(i, false);
        }
    }

    static final Configuration getConfiguration(Attachable attachable) {
        if (attachable instanceof AttachableInternal) {
            return ((AttachableInternal)attachable).configuration();
        }
        return null;
    }

    static Configuration configuration(Attachable attachable) {
        return Utils.configuration(attachable instanceof AttachableInternal ? ((AttachableInternal)attachable).configuration() : null);
    }

    static Configuration configuration(Configuration configuration) {
        return configuration != null ? configuration : new DefaultConfiguration();
    }

    static Settings settings(Attachable attachable) {
        return Utils.configuration(attachable).settings();
    }

    static Settings settings(Configuration configuration) {
        return Utils.configuration(configuration).settings();
    }

    static final boolean attachRecords(Configuration configuration) {
        Settings settings;
        if (configuration != null && (settings = configuration.settings()) != null) {
            return !Boolean.FALSE.equals(settings.isAttachRecords());
        }
        return true;
    }

    static final Field<?>[] fieldArray(Collection<? extends Field<?>> fields) {
        return fields == null ? null : fields.toArray(new Field[fields.size()]);
    }

    static final Class<?>[] types(Field<?>[] fields) {
        return Utils.types(Utils.dataTypes(fields));
    }

    static final Class<?>[] types(DataType<?>[] types) {
        if (types == null) {
            return null;
        }
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i] != null ? types[i].getType() : Object.class;
        }
        return result;
    }

    static final Class<?>[] types(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] instanceof Field ? ((Field)values[i]).getType() : (values[i] != null ? values[i].getClass() : Object.class);
        }
        return result;
    }

    static final DataType<?>[] dataTypes(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        DataType[] result = new DataType[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i] != null ? fields[i].getDataType() : DSL.getDataType(Object.class);
        }
        return result;
    }

    static final DataType<?>[] dataTypes(Class<?>[] types) {
        if (types == null) {
            return null;
        }
        DataType[] result = new DataType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i] != null ? DSL.getDataType(types[i]) : DSL.getDataType(Object.class);
        }
        return result;
    }

    static final DataType<?>[] dataTypes(Object[] values) {
        return Utils.dataTypes(Utils.types(values));
    }

    static final String[] fieldNames(int length) {
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = "v" + i;
        }
        return result;
    }

    static final String[] fieldNames(Field<?>[] fields) {
        String[] result = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].getName();
        }
        return result;
    }

    static final Field<?>[] fields(int length) {
        Field[] result = new Field[length];
        String[] names = Utils.fieldNames(length);
        for (int i = 0; i < length; ++i) {
            result[i] = DSL.field(DSL.name(names[i]));
        }
        return result;
    }

    static final Field<?>[] aliasedFields(Field<?>[] fields, String[] aliases) {
        Field[] result = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].as(aliases[i]);
        }
        return result;
    }

    static final Field<?>[] fieldsByName(String[] fieldNames) {
        return Utils.fieldsByName(null, fieldNames);
    }

    static final Field<?>[] fieldsByName(String tableName, String[] fieldNames) {
        Field[] result = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = tableName == null ? DSL.field(DSL.name(fieldNames[i])) : DSL.field(DSL.name(tableName, fieldNames[i]));
        }
        return result;
    }

    static final Field<?>[] fieldsByName(Name[] names) {
        Field[] result = new Field[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = DSL.field(names[i]);
        }
        return result;
    }

    static final Name[] names(String[] names) {
        Name[] result = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = DSL.name(names[i]);
        }
        return result;
    }

    static final <T> Field<T> field(T value) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value);
    }

    @Deprecated
    static final Field<Object> field(Name name) {
        return DSL.field(name);
    }

    static final <T> Field<T> field(Object value, Field<T> field) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value, field);
    }

    static final <T> Field<T> field(Object value, Class<T> type) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value, type);
    }

    static final <T> Field<T> field(Object value, DataType<T> type) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value, type);
    }

    static final <T> List<Field<T>> fields(T[] values) {
        ArrayList<Field<T>> result = new ArrayList<Field<T>>();
        if (values != null) {
            for (T value : values) {
                result.add(Utils.field(value));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Field<?> field) {
        ArrayList result = new ArrayList();
        if (values != null && field != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(Utils.field(values[i], field));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Field<?>[] fields) {
        ArrayList result = new ArrayList();
        if (values != null && fields != null) {
            for (int i = 0; i < values.length && i < fields.length; ++i) {
                result.add(Utils.field(values[i], fields[i]));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Class<?> type) {
        ArrayList result = new ArrayList();
        if (values != null && type != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(Utils.field(values[i], type));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Class<?>[] types) {
        ArrayList result = new ArrayList();
        if (values != null && types != null) {
            for (int i = 0; i < values.length && i < types.length; ++i) {
                result.add(Utils.field(values[i], types[i]));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, DataType<?> type) {
        ArrayList result = new ArrayList();
        if (values != null && type != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(Utils.field(values[i], type));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, DataType<?>[] types) {
        ArrayList result = new ArrayList();
        if (values != null && types != null) {
            for (int i = 0; i < values.length && i < types.length; ++i) {
                result.add(Utils.field(values[i], types[i]));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Collection<? extends SelectField<?>> fields) {
        ArrayList result = new ArrayList();
        if (fields != null) {
            for (SelectField<?> field : fields) {
                result.add(DSL.field(field));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(SelectField<?> ... fields) {
        return fields == null ? Utils.fields(Collections.emptyList()) : Utils.fields(Arrays.asList(fields));
    }

    static final <T> List<Field<T>> inline(T[] values) {
        ArrayList<Field<T>> result = new ArrayList<Field<T>>();
        if (values != null) {
            for (T value : values) {
                result.add(DSL.inline(value));
            }
        }
        return result;
    }

    static final List<Field<?>> unqualify(List<? extends Field<?>> fields) {
        QueryPartList result = new QueryPartList();
        for (Field<?> field : fields) {
            result.add(DSL.field(DSL.name(field.getName())));
        }
        return result;
    }

    static final int indexOrFail(Row row, Field<?> field) {
        int result = row.indexOf(field);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + field + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(Row row, String fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(Row row, Name fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, Field<?> field) {
        int result = row.indexOf(field);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + field + ") is not contained in RecordType " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, String fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in RecordType " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, Name fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in RecordType " + row);
        }
        return result;
    }

    @SafeVarargs
    static final <T> T[] array(T ... array) {
        return array;
    }

    @SafeVarargs
    static final <T> List<T> list(T ... array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    static final Map<Field<?>, Object> mapOfChangedValues(Record record) {
        LinkedHashMap result = new LinkedHashMap();
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            if (!record.changed(i)) continue;
            result.put(record.field(i), record.getValue(i));
        }
        return result;
    }

    static final <T> T first(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    static final <R extends Record> R filterOne(List<R> list) throws TooManyRowsException {
        int size = list.size();
        if (size == 1) {
            return (R)((Record)list.get(0));
        }
        if (size > 1) {
            throw new TooManyRowsException("Too many rows selected : " + size);
        }
        return null;
    }

    static final <R extends Record> R fetchOne(Cursor<R> cursor) throws TooManyRowsException {
        try {
            R record = cursor.fetchOne();
            if (cursor.hasNext()) {
                throw new TooManyRowsException("Cursor returned more than one result");
            }
            R r = record;
            return r;
        }
        finally {
            cursor.close();
        }
    }

    static final <C extends Context<? super C>> C visitAll(C ctx, Collection<? extends QueryPart> parts) {
        if (parts != null) {
            for (QueryPart queryPart : parts) {
                ctx.visit(queryPart);
            }
        }
        return ctx;
    }

    static final <C extends Context<? super C>> C visitAll(C ctx, QueryPart[] parts) {
        if (parts != null) {
            for (QueryPart part : parts) {
                ctx.visit(part);
            }
        }
        return ctx;
    }

    static final void renderAndBind(Context<?> ctx, String sql, List<QueryPart> substitutes) {
        RenderContext render = (RenderContext)(ctx instanceof RenderContext ? ctx : null);
        BindContext bind = (BindContext)(ctx instanceof BindContext ? ctx : null);
        int substituteIndex = 0;
        char[] sqlChars = sql.toCharArray();
        if (render == null) {
            render = new DefaultRenderContext(bind.configuration());
        }
        SQLDialect dialect = render.configuration().dialect();
        SQLDialect family = dialect.family();
        boolean mysql = Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)family);
        String[][] quotes = Identifiers.QUOTES.get((Object)family);
        boolean needsBackslashEscaping = Utils.needsBackslashEscaping(ctx.configuration());
        for (int i = 0; i < sqlChars.length; ++i) {
            if (Utils.peek(sqlChars, i, "--") || mysql && Utils.peek(sqlChars, i, "#")) {
                while (i < sqlChars.length && sqlChars[i] != '\r' && sqlChars[i] != '\n') {
                    render.sql(sqlChars[i++]);
                }
                if (i >= sqlChars.length) continue;
                render.sql(sqlChars[i]);
                continue;
            }
            if (Utils.peek(sqlChars, i, "/*")) {
                while (!Utils.peek(sqlChars, i, "*/")) {
                    render.sql(sqlChars[i++]);
                }
                render.sql(sqlChars[i++]);
                render.sql(sqlChars[i]);
                continue;
            }
            if (sqlChars[i] == '\'') {
                render.sql(sqlChars[i++]);
                while (true) {
                    if (sqlChars[i] == '\\' && needsBackslashEscaping) {
                        render.sql(sqlChars[i++]);
                    } else if (Utils.peek(sqlChars, i, "''")) {
                        render.sql(sqlChars[i++]);
                    } else if (Utils.peek(sqlChars, i, "'")) break;
                    render.sql(sqlChars[i++]);
                }
                render.sql(sqlChars[i]);
                continue;
            }
            if (Utils.peekAny(sqlChars, i, quotes[0])) {
                int d;
                int delimiter = 0;
                for (d = 0; d < quotes[0].length; ++d) {
                    if (!Utils.peek(sqlChars, i, quotes[0][d])) continue;
                    delimiter = d;
                    break;
                }
                for (d = 0; d < quotes[0][delimiter].length(); ++d) {
                    render.sql(sqlChars[i++]);
                }
                while (true) {
                    if (Utils.peek(sqlChars, i, quotes[2][delimiter])) {
                        for (d = 0; d < quotes[2][delimiter].length(); ++d) {
                            render.sql(sqlChars[i++]);
                        }
                    } else if (Utils.peek(sqlChars, i, quotes[1][delimiter])) break;
                    render.sql(sqlChars[i++]);
                }
                for (d = 0; d < quotes[1][delimiter].length(); ++d) {
                    if (d > 0) {
                        ++i;
                    }
                    render.sql(sqlChars[i]);
                }
                continue;
            }
            if (sqlChars[i] == '?' && substituteIndex < substitutes.size()) {
                QueryPart substitute = substitutes.get(substituteIndex++);
                if (render.paramType() == ParamType.INLINED || render.paramType() == ParamType.NAMED || render.paramType() == ParamType.NAMED_OR_INLINED) {
                    render.visit(substitute);
                } else {
                    render.sql(sqlChars[i]);
                }
                if (bind == null) continue;
                bind.visit(substitute);
                continue;
            }
            if (sqlChars[i] == '{') {
                if (Utils.peekAny(sqlChars, i, JDBC_ESCAPE_PREFIXES, true)) {
                    render.sql(sqlChars[i]);
                    continue;
                }
                int start = ++i;
                while (i < sqlChars.length && sqlChars[i] != '}') {
                    ++i;
                }
                int end = i;
                String token = sql.substring(start, end);
                try {
                    QueryPart substitute = substitutes.get(Integer.valueOf(token));
                    render.visit(substitute);
                    if (bind == null) continue;
                    bind.visit(substitute);
                }
                catch (NumberFormatException e) {
                    render.keyword(token);
                }
                continue;
            }
            render.sql(sqlChars[i]);
        }
    }

    static final boolean needsBackslashEscaping(Configuration configuration) {
        BackslashEscaping escaping = SettingsTools.getBackslashEscaping(configuration.settings());
        return escaping == BackslashEscaping.ON || escaping == BackslashEscaping.DEFAULT && EnumSet.of(SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)configuration.dialect().family());
    }

    static final boolean peek(char[] sqlChars, int index, String peek) {
        return Utils.peek(sqlChars, index, peek, false);
    }

    static final boolean peek(char[] sqlChars, int index, String peek, boolean anyWhitespace) {
        char[] peekArray = peek.toCharArray();
        block0: for (int i = 0; i < peekArray.length; ++i) {
            if (index + i >= sqlChars.length) {
                return false;
            }
            if (sqlChars[index + i] == peekArray[i]) continue;
            if (anyWhitespace && peekArray[i] == ' ') {
                for (int j = 0; j < WHITESPACE.length(); ++j) {
                    if (sqlChars[index + i] == WHITESPACE.charAt(j)) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    static final boolean peekAny(char[] sqlChars, int index, String[] peekAny) {
        return Utils.peekAny(sqlChars, index, peekAny, false);
    }

    static final boolean peekAny(char[] sqlChars, int index, String[] peekAny, boolean anyWhitespace) {
        for (String peek : peekAny) {
            if (!Utils.peek(sqlChars, index, peek, anyWhitespace)) continue;
            return true;
        }
        return false;
    }

    static final List<QueryPart> queryParts(Object ... substitutes) {
        if (substitutes == null) {
            return Utils.queryParts(new Object[]{null});
        }
        ArrayList<QueryPart> result = new ArrayList<QueryPart>();
        for (Object substitute : substitutes) {
            if (substitute instanceof QueryPart) {
                result.add((QueryPart)substitute);
                continue;
            }
            Class type = substitute != null ? substitute.getClass() : Object.class;
            result.add(new Val<Object>(substitute, DSL.getDataType(type)));
        }
        return result;
    }

    static final void fieldNames(Context<?> context, Fields<?> fields) {
        Utils.fieldNames(context, Utils.list(fields.fields));
    }

    static final void fieldNames(Context<?> context, Field<?> ... fields) {
        Utils.fieldNames(context, Utils.list(fields));
    }

    static final void fieldNames(Context<?> context, Collection<? extends Field<?>> list) {
        String separator = "";
        for (Field<?> field : list) {
            context.sql(separator).literal(field.getName());
            separator = ", ";
        }
    }

    static final void tableNames(Context<?> context, Table<?> ... list) {
        Utils.tableNames(context, Utils.list(list));
    }

    static final void tableNames(Context<?> context, Collection<? extends Table<?>> list) {
        String separator = "";
        for (Table<?> table : list) {
            context.sql(separator).literal(table.getName());
            separator = ", ";
        }
    }

    static final <T> T[] combine(T[] array, T value) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = value;
        return result;
    }

    static final Field<?>[] combine(Field<?> field, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field};
        }
        Field[] result = new Field[fields.length + 1];
        result[0] = field;
        System.arraycopy(fields, 0, result, 1, fields.length);
        return result;
    }

    static final Field<?>[] combine(Field<?> field1, Field<?> field2, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field1, field2};
        }
        Field[] result = new Field[fields.length + 2];
        result[0] = field1;
        result[1] = field2;
        System.arraycopy(fields, 0, result, 2, fields.length);
        return result;
    }

    static final Field<?>[] combine(Field<?> field1, Field<?> field2, Field<?> field3, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field1, field2, field3};
        }
        Field[] result = new Field[fields.length + 3];
        result[0] = field1;
        result[1] = field2;
        result[2] = field3;
        System.arraycopy(fields, 0, result, 3, fields.length);
        return result;
    }

    static final DataAccessException translate(String sql, SQLException e) {
        String message = "SQL [" + sql + "]; " + e.getMessage();
        return new DataAccessException(message, e);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx) {
        Utils.safeClose(listener, ctx, false);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx, boolean keepStatement) {
        Utils.safeClose(listener, ctx, keepStatement, true);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx, boolean keepStatement, boolean keepResultSet) {
        JDBCUtils.safeClose(ctx.resultSet());
        ctx.resultSet(null);
        PreparedStatement statement = ctx.statement();
        if (statement != null) {
            Utils.consumeWarnings(ctx, listener);
        }
        if (!keepStatement) {
            if (statement != null) {
                JDBCUtils.safeClose(statement);
                ctx.statement(null);
            } else {
                Connection connection = DefaultExecuteContext.localConnection();
                if (connection != null) {
                    ctx.configuration().connectionProvider().release(connection);
                }
            }
        }
        if (keepResultSet) {
            listener.end(ctx);
        }
        DefaultExecuteContext.clean();
    }

    static final <T> void setValue(Record target, Field<T> targetField, Record source, Field<?> sourceField) {
        Utils.setValue(target, targetField, source.getValue(sourceField));
    }

    static final <T> void setValue(Record target, Field<T> targetField, Object value) {
        target.setValue(targetField, targetField.getDataType().convert(value));
    }

    static final <T> void copyValue(AbstractRecord target, Field<T> targetField, Record source, Field<?> sourceField) {
        DataType<T> targetType = targetField.getDataType();
        int targetIndex = Utils.indexOrFail(target.fieldsRow(), targetField);
        int sourceIndex = Utils.indexOrFail(source.fieldsRow(), sourceField);
        target.values[targetIndex] = targetType.convert(source.getValue(sourceIndex));
        target.originals[targetIndex] = targetType.convert(source.original(sourceIndex));
        target.changed.set(targetIndex, source.changed(sourceIndex));
    }

    static final Schema getMappedSchema(Configuration configuration, Schema schema) {
        SchemaMapping mapping = configuration.schemaMapping();
        if (mapping != null) {
            return mapping.map(schema);
        }
        return schema;
    }

    static final <R extends Record> Table<R> getMappedTable(Configuration configuration, Table<R> table) {
        SchemaMapping mapping = configuration.schemaMapping();
        if (mapping != null) {
            return mapping.map(table);
        }
        return table;
    }

    static final String getMappedUDTName(Configuration configuration, Class<? extends UDTRecord<?>> type) {
        return Utils.getMappedUDTName(configuration, Utils.newRecord(false, type).operate(null));
    }

    static final String getMappedUDTName(Configuration configuration, UDTRecord<?> record) {
        UDT<?> udt = record.getUDT();
        Schema mapped = Utils.getMappedSchema(configuration, udt.getSchema());
        StringBuilder sb = new StringBuilder();
        if (mapped != null) {
            sb.append(mapped.getName()).append('.');
        }
        sb.append(record.getUDT().getName());
        return sb.toString();
    }

    static final int hash(Object object) {
        return 0x7FFFFFF & object.hashCode();
    }

    static final Field<String> escapeForLike(Object value) {
        return Utils.escapeForLike(value, (Configuration)new DefaultConfiguration());
    }

    static final Field<String> escapeForLike(Object value, Configuration configuration) {
        if (value != null && value.getClass() == String.class) {
            return DSL.val(DSL.escape("" + value, '!'));
        }
        return DSL.val("" + value);
    }

    static final Field<String> escapeForLike(Field<?> field) {
        return Utils.escapeForLike(field, (Configuration)new DefaultConfiguration());
    }

    static final Field<String> escapeForLike(Field<?> field, Configuration configuration) {
        if (DSL.nullSafe(field).getDataType().isString()) {
            return DSL.escape(field, '!');
        }
        return field.cast(String.class);
    }

    static final boolean isVal(Field<?> field) {
        return field instanceof Param;
    }

    static final <T> T extractVal(Field<T> field) {
        if (Utils.isVal(field)) {
            return ((Param)field).getValue();
        }
        return null;
    }

    static final void addConditions(ConditionProvider query, Record record, Field<?> ... keys) {
        for (Field<?> field : keys) {
            Utils.addCondition(query, record, field);
        }
    }

    static final <T> void addCondition(ConditionProvider provider, Record record, Field<T> field) {
        if (SettingsTools.updatablePrimaryKeys(Utils.settings(record))) {
            provider.addConditions(Utils.condition(field, record.original(field)));
        } else {
            provider.addConditions(Utils.condition(field, record.getValue(field)));
        }
    }

    static final <T> Condition condition(Field<T> field, T value) {
        return value == null ? field.isNull() : field.eq(value);
    }

    private static final boolean isJPAAvailable() {
        if (isJPAAvailable == null) {
            try {
                Class.forName(Column.class.getName());
                isJPAAvailable = true;
            }
            catch (Throwable e) {
                isJPAAvailable = false;
            }
        }
        return isJPAAvailable;
    }

    static final boolean hasColumnAnnotations(Configuration configuration, final Class<?> type) {
        return Cache.run(configuration, new Cache.CachedOperation<Boolean>(){

            @Override
            public Boolean call() {
                if (!Utils.isJPAAvailable()) {
                    return false;
                }
                if (type.getAnnotation(Entity.class) != null) {
                    return true;
                }
                if (type.getAnnotation(javax.persistence.Table.class) != null) {
                    return true;
                }
                for (java.lang.reflect.Field member : Utils.getInstanceMembers(type)) {
                    if (member.getAnnotation(Column.class) != null) {
                        return true;
                    }
                    if (member.getAnnotation(Id.class) == null) continue;
                    return true;
                }
                for (Method method : Utils.getInstanceMethods(type)) {
                    if (method.getAnnotation(Column.class) == null) continue;
                    return true;
                }
                return false;
            }
        }, DATA_REFLECTION_CACHE_HAS_COLUMN_ANNOTATIONS, type);
    }

    static final List<java.lang.reflect.Field> getAnnotatedMembers(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new Cache.CachedOperation<List<java.lang.reflect.Field>>(){

            @Override
            public List<java.lang.reflect.Field> call() {
                ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
                for (java.lang.reflect.Field member : Utils.getInstanceMembers(type)) {
                    Column column = member.getAnnotation(Column.class);
                    if (column != null) {
                        if (!Utils.namesMatch(name, column.name())) continue;
                        result.add(Reflect.accessible(member));
                        continue;
                    }
                    Id id = member.getAnnotation(Id.class);
                    if (id == null || !Utils.namesMatch(name, member.getName())) continue;
                    result.add(Reflect.accessible(member));
                }
                return result;
            }
        }, DATA_REFLECTION_CACHE_GET_ANNOTATED_MEMBERS, type, name);
    }

    private static final boolean namesMatch(String name, String annotation) {
        return annotation.startsWith("\"") ? ('\"' + name + '\"').equals(annotation) : name.equalsIgnoreCase(annotation);
    }

    static final List<java.lang.reflect.Field> getMatchingMembers(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new Cache.CachedOperation<List<java.lang.reflect.Field>>(){

            @Override
            public List<java.lang.reflect.Field> call() {
                ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
                String camelCaseLC = StringUtils.toCamelCaseLC(name);
                for (java.lang.reflect.Field member : Utils.getInstanceMembers(type)) {
                    if (name.equals(member.getName())) {
                        result.add(Reflect.accessible(member));
                        continue;
                    }
                    if (!camelCaseLC.equals(member.getName())) continue;
                    result.add(Reflect.accessible(member));
                }
                return result;
            }
        }, DATA_REFLECTION_CACHE_GET_MATCHING_MEMBERS, type, name);
    }

    static final List<Method> getAnnotatedSetters(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new Cache.CachedOperation<List<Method>>(){

            @Override
            public List<Method> call() {
                ArrayList<Method> result = new ArrayList<Method>();
                for (Method method : Utils.getInstanceMethods(type)) {
                    String m;
                    String suffix;
                    Column column = method.getAnnotation(Column.class);
                    if (column == null || !Utils.namesMatch(name, column.name())) continue;
                    if (method.getParameterTypes().length == 1) {
                        result.add(Reflect.accessible(method));
                        continue;
                    }
                    if (method.getParameterTypes().length != 0 || (suffix = (m = method.getName()).startsWith("get") ? m.substring(3) : (m.startsWith("is") ? m.substring(2) : null)) == null) continue;
                    try {
                        Method setter = type.getMethod("set" + suffix, method.getReturnType());
                        if (setter.getAnnotation(Column.class) != null) continue;
                        result.add(Reflect.accessible(setter));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                return result;
            }
        }, DATA_REFLECTION_CACHE_GET_ANNOTATED_SETTERS, type, name);
    }

    static final Method getAnnotatedGetter(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new Cache.CachedOperation<Method>(){

            @Override
            public Method call() {
                for (Method method : Utils.getInstanceMethods(type)) {
                    Method getter2;
                    String m;
                    Column column = method.getAnnotation(Column.class);
                    if (column == null || !Utils.namesMatch(name, column.name())) continue;
                    if (method.getParameterTypes().length == 0) {
                        return Reflect.accessible(method);
                    }
                    if (method.getParameterTypes().length != 1 || !(m = method.getName()).startsWith("set")) continue;
                    try {
                        getter2 = type.getMethod("get" + m.substring(3), new Class[0]);
                        if (getter2.getAnnotation(Column.class) == null) {
                            return Reflect.accessible(getter2);
                        }
                    }
                    catch (NoSuchMethodException getter2) {
                        // empty catch block
                    }
                    try {
                        getter2 = type.getMethod("is" + m.substring(3), new Class[0]);
                        if (getter2.getAnnotation(Column.class) != null) continue;
                        return Reflect.accessible(getter2);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                return null;
            }
        }, DATA_REFLECTION_CACHE_GET_ANNOTATED_GETTER, type, name);
    }

    static final List<Method> getMatchingSetters(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new Cache.CachedOperation<List<Method>>(){

            @Override
            public List<Method> call() {
                ArrayList<Method> result = new ArrayList<Method>();
                String camelCase = StringUtils.toCamelCase(name);
                String camelCaseLC = StringUtils.toLC(camelCase);
                for (Method method : Utils.getInstanceMethods(type)) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) continue;
                    if (name.equals(method.getName())) {
                        result.add(Reflect.accessible(method));
                        continue;
                    }
                    if (camelCaseLC.equals(method.getName())) {
                        result.add(Reflect.accessible(method));
                        continue;
                    }
                    if (("set" + name).equals(method.getName())) {
                        result.add(Reflect.accessible(method));
                        continue;
                    }
                    if (!("set" + camelCase).equals(method.getName())) continue;
                    result.add(Reflect.accessible(method));
                }
                return result;
            }
        }, DATA_REFLECTION_CACHE_GET_MATCHING_SETTERS, type, name);
    }

    static final Method getMatchingGetter(Configuration configuration, final Class<?> type, final String name) {
        return Cache.run(configuration, new Cache.CachedOperation<Method>(){

            @Override
            public Method call() {
                String camelCase = StringUtils.toCamelCase(name);
                String camelCaseLC = StringUtils.toLC(camelCase);
                for (Method method : Utils.getInstanceMethods(type)) {
                    if (method.getParameterTypes().length != 0) continue;
                    if (name.equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (camelCaseLC.equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (("get" + name).equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (("get" + camelCase).equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (("is" + name).equals(method.getName())) {
                        return Reflect.accessible(method);
                    }
                    if (!("is" + camelCase).equals(method.getName())) continue;
                    return Reflect.accessible(method);
                }
                return null;
            }
        }, DATA_REFLECTION_CACHE_GET_MATCHING_GETTER, type, name);
    }

    private static final List<Method> getInstanceMethods(Class<?> type) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            result.add(method);
        }
        return result;
    }

    private static final List<java.lang.reflect.Field> getInstanceMembers(Class<?> type) {
        ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : type.getFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            result.add(field);
        }
        do {
            for (java.lang.reflect.Field field : type.getDeclaredFields()) {
                if ((field.getModifiers() & 8) != 0) continue;
                result.add(field);
            }
        } while ((type = type.getSuperclass()) != null);
        return result;
    }

    static final String getPropertyName(String methodName) {
        String name = methodName;
        if (name.startsWith("is") && name.length() > 2) {
            name = name.substring(2, 3).toLowerCase() + name.substring(3);
        } else if (name.startsWith("get") && name.length() > 3) {
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
        } else if (name.startsWith("set") && name.length() > 3) {
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    static final void consumeExceptions(Configuration configuration, PreparedStatement stmt, SQLException previous) {
    }

    static final void consumeWarnings(ExecuteContext ctx, ExecuteListener listener) {
        if (!Boolean.FALSE.equals(ctx.settings().isFetchWarnings())) {
            try {
                ctx.sqlWarning(ctx.statement().getWarnings());
            }
            catch (SQLException e) {
                ctx.sqlWarning(new SQLWarning("Could not fetch SQLWarning", e));
            }
        }
        if (ctx.sqlWarning() != null) {
            listener.warning(ctx);
        }
    }

    static void consumeResultSets(ExecuteContext ctx, ExecuteListener listener, Results results, Intern intern) throws SQLException {
        boolean anyResults = false;
        int i = 0;
        int rows = ctx.resultSet() == null ? ctx.statement().getUpdateCount() : 0;
        for (i = 0; i < maxConsumedResults; ++i) {
            if (ctx.resultSet() != null) {
                anyResults = true;
                Field<?>[] fields = new MetaDataFieldProvider(ctx.configuration(), ctx.resultSet().getMetaData()).getFields();
                CursorImpl c = new CursorImpl(ctx, listener, fields, intern != null ? intern.internIndexes(fields) : null, true, false);
                results.resultsOrRows().add(new ResultsImpl.ResultOrRowsImpl(c.fetch()));
            } else {
                if (rows == -1) break;
                results.resultsOrRows().add(new ResultsImpl.ResultOrRowsImpl(rows));
            }
            if (ctx.statement().getMoreResults()) {
                ctx.resultSet(ctx.statement().getResultSet());
                continue;
            }
            rows = ctx.statement().getUpdateCount();
            if (rows == -1) break;
            ctx.resultSet(null);
        }
        if (i == maxConsumedResults) {
            log.warn("Maximum consumed results reached: " + maxConsumedResults + ". This is probably a bug. Please report to https://github.com/jOOQ/jOOQ/issues/new");
        }
        if (anyResults && ctx.family() != SQLDialect.CUBRID) {
            ctx.statement().getMoreResults(3);
        }
    }

    static List<String[]> parseTXT(String string, String nullLiteral) {
        boolean formatted;
        String[] strings = string.split("[\\r\\n]+");
        if (strings.length < 2) {
            throw new DataAccessException("String must contain at least two lines");
        }
        boolean bl = formatted = string.charAt(0) == '+';
        if (formatted) {
            return Utils.parseTXTLines(nullLiteral, strings, PLUS_PATTERN, 0, 1, 3, strings.length - 1);
        }
        return Utils.parseTXTLines(nullLiteral, strings, DASH_PATTERN, 1, 0, 2, strings.length);
    }

    private static List<String[]> parseTXTLines(String nullLiteral, String[] strings, Pattern pattern, int matchLine, int headerLine, int dataLineStart, int dataLineEnd) {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        Matcher m = pattern.matcher(strings[matchLine]);
        while (m.find()) {
            positions.add(new int[]{m.start(1), m.end(1)});
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        Utils.parseTXTLine(positions, result, strings[headerLine], nullLiteral);
        for (int j = dataLineStart; j < dataLineEnd; ++j) {
            Utils.parseTXTLine(positions, result, strings[j], nullLiteral);
        }
        return result;
    }

    private static void parseTXTLine(List<int[]> positions, List<String[]> result, String string, String nullLiteral) {
        String[] fields = new String[positions.size()];
        result.add(fields);
        int length = string.length();
        for (int i = 0; i < fields.length; ++i) {
            int[] position = positions.get(i);
            fields[i] = position[0] < length ? string.substring(position[0], Math.min(position[1], length)).trim() : null;
            if (!StringUtils.equals(fields[i], nullLiteral)) continue;
            fields[i] = null;
        }
    }

    static void executeImmediateBegin(Context<?> ctx, DropStatementType type) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.keyword("execute block").formatSeparator().keyword("as").formatSeparator().keyword("begin").formatIndentStart().formatSeparator().keyword("execute statement").sql(" '");
                break;
            }
        }
    }

    static void executeImmediateEnd(Context<?> ctx, DropStatementType type) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.sql("';").formatSeparator().keyword("when").sql(" sqlcode -607 ").keyword("do").formatIndentStart().formatSeparator().keyword("begin end").formatIndentEnd().formatIndentEnd().formatSeparator().keyword("end");
                break;
            }
        }
    }

    static void toSQLDDLTypeDeclaration(Context<?> ctx, DataType<?> type) {
        String typeName = type.getTypeName(ctx.configuration());
        if (type.hasLength()) {
            if (type.length() > 0) {
                ctx.keyword(typeName).sql('(').sql(type.length()).sql(')');
            } else {
                String castTypeName = type.getCastTypeName(ctx.configuration());
                if (!typeName.equals(castTypeName)) {
                    ctx.keyword(castTypeName);
                } else {
                    ctx.keyword(typeName);
                }
            }
        } else if (type.hasPrecision() && type.precision() > 0) {
            if (type.hasScale()) {
                ctx.keyword(typeName).sql('(').sql(type.precision()).sql(", ").sql(type.scale()).sql(')');
            } else {
                ctx.keyword(typeName).sql('(').sql(type.precision()).sql(')');
            }
        } else {
            ctx.keyword(typeName);
        }
    }

    static {
        maxConsumedExceptions = 256;
        maxConsumedResults = 65536;
        DASH_PATTERN = Pattern.compile("(-+)");
        PLUS_PATTERN = Pattern.compile("\\+(-+)(?=\\+)");
        JDBC_ESCAPE_PREFIXES = new String[]{"{fn ", "{d ", "{t ", "{ts "};
    }

    static class Cache {
        private static final Object NULL = new Object();

        Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final <V> V run(Configuration configuration, CachedOperation<V> operation, String type, Object ... keys) {
            Object key;
            Object result;
            if (configuration == null) {
                configuration = new DefaultConfiguration();
            }
            if (!SettingsTools.reflectionCaching(configuration.settings())) {
                return operation.call();
            }
            ConcurrentHashMap<Object, Object> cache = (ConcurrentHashMap<Object, Object>)configuration.data(type);
            if (cache == null) {
                String string = type;
                synchronized (string) {
                    cache = (Map)configuration.data(type);
                    if (cache == null) {
                        cache = new ConcurrentHashMap<Object, Object>();
                        configuration.data(type, cache);
                    }
                }
            }
            if ((result = cache.get(key = Cache.key(keys))) == null) {
                ConcurrentHashMap<Object, Object> concurrentHashMap = cache;
                synchronized (concurrentHashMap) {
                    result = cache.get(key);
                    if (result == null) {
                        result = operation.call();
                        cache.put(key, result == null ? NULL : result);
                    }
                }
            }
            return result == NULL ? null : (V)result;
        }

        private static final Object key(Object ... key) {
            if (key == null || key.length == 0) {
                return key;
            }
            if (key.length == 1) {
                return key[0];
            }
            return new Key(key);
        }

        private static class Key {
            private final Object[] key;

            Key(Object[] key) {
                this.key = key;
            }

            public int hashCode() {
                return Arrays.hashCode(this.key);
            }

            public boolean equals(Object obj) {
                if (obj instanceof Key) {
                    return Arrays.equals(this.key, ((Key)obj).key);
                }
                return false;
            }

            public String toString() {
                return Arrays.asList(this.key).toString();
            }
        }

        static interface CachedOperation<V> {
            public V call();
        }
    }

    static class ThreadGuard {
        ThreadGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final <V> V run(Guard guard, GuardedOperation<V> operation) {
            boolean unguarded;
            boolean bl = unguarded = guard.tl.get() == null;
            if (unguarded) {
                guard.tl.set(Guard.class);
            }
            try {
                if (unguarded) {
                    V v = operation.unguarded();
                    return v;
                }
                V v = operation.guarded();
                return v;
            }
            finally {
                if (unguarded) {
                    guard.tl.remove();
                }
            }
        }

        static abstract class AbstractGuardedOperation<V>
        implements GuardedOperation<V> {
            AbstractGuardedOperation() {
            }

            @Override
            public V guarded() {
                return null;
            }
        }

        static interface GuardedOperation<V> {
            public V unguarded();

            public V guarded();
        }

        static enum Guard {
            RECORD_TOSTRING;

            ThreadLocal<Object> tl = new ThreadLocal();
        }
    }

    static enum DataKey {
        DATA_OMIT_RETURNING_CLAUSE,
        DATA_ROW_VALUE_EXPRESSION_PREDICATE_SUBQUERY,
        DATA_LOCK_ROWS_FOR_UPDATE,
        DATA_COUNT_BIND_VALUES,
        DATA_FORCE_STATIC_STATEMENT,
        DATA_OMIT_CLAUSE_EVENT_EMISSION,
        DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES,
        DATA_LOCALLY_SCOPED_DATA_MAP,
        DATA_WINDOW_DEFINITIONS,
        DATA_DEFAULT_TRANSACTION_PROVIDER_AUTOCOMMIT,
        DATA_DEFAULT_TRANSACTION_PROVIDER_SAVEPOINTS,
        DATA_DEFAULT_TRANSACTION_PROVIDER_CONNECTION,
        DATA_OVERRIDE_ALIASES_IN_ORDER_BY,
        DATA_UNALIAS_ALIASES_IN_ORDER_BY,
        DATA_SELECT_INTO_TABLE,
        DATA_OMIT_INTO_CLAUSE,
        DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE,
        DATA_LIST_ALREADY_INDENTED,
        DATA_DROP_CONSTRAINT,
        DATA_COLLECT_SEMI_ANTI_JOIN,
        DATA_COLLECTED_SEMI_ANTI_JOIN;

    }
}

