/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;

class RowIsNull
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES_NULL = new Clause[]{Clause.CONDITION, Clause.CONDITION_IS_NULL};
    private static final Clause[] CLAUSES_NOT_NULL = new Clause[]{Clause.CONDITION, Clause.CONDITION_IS_NOT_NULL};
    private final Row row;
    private final boolean isNull;

    RowIsNull(Row row, boolean isNull) {
        this.row = row;
        this.isNull = isNull;
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.delegate(ctx.configuration()).accept(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.delegate(ctx.configuration()).clauses(ctx);
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE).contains((Object)configuration.dialect().family())) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (Field<?> field : this.row.fields()) {
                conditions.add(this.isNull ? field.isNull() : field.isNotNull());
            }
            Condition result = DSL.and(conditions);
            return (QueryPartInternal)((Object)result);
        }
        return new Native();
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -2977241780111574353L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(RowIsNull.this.row).sql(' ').keyword(RowIsNull.this.isNull ? "is null" : "is not null");
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return RowIsNull.this.isNull ? CLAUSES_NULL : CLAUSES_NOT_NULL;
        }
    }
}

