/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.validator.collection.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationUtils.class);

    public static <T> T readAttribute(Annotation annotation, String name, Class<T> requiredType) throws IllegalArgumentException, IllegalStateException {
        Object result = AnnotationUtils.invokeNonArgMethod(annotation, name);
        Validate.isInstanceOf(requiredType, (Object)result, (String)"Method %s should return instance of %s", (Object[])new Object[]{name, requiredType.getSimpleName()});
        return (T)result;
    }

    public static boolean hasAttribute(Class<? extends Annotation> annotationType, String attributeName) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(attributeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class<?> getAttributeType(Class<? extends Annotation> annotationType, String attributeName) {
        try {
            return annotationType.getDeclaredMethod(attributeName, new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(String.format("No such attribute %s in %s", attributeName, annotationType.getName()), ex);
        }
    }

    public static Map<String, Object> readAllAttributes(Annotation annotation) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Method[] methodArray = annotation.annotationType().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                attributes.put(method.getName(), value);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new IllegalStateException(ex);
            }
            ++n2;
        }
        return attributes;
    }

    public static <T extends Annotation> T createAnnotation(Class<T> annotationType, Map<String, Object> attributes) {
        Iterator<String> it = attributes.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next();
            Object value = attributes.get(name);
            if (value == null) {
                LOG.warn("Attribute's value must not be null; will be ignored");
                it.remove();
                continue;
            }
            if (!AnnotationUtils.hasAttribute(annotationType, name)) {
                LOG.warn("Annotation {} does not define attribute: {}; will be ignored", (Object)annotationType.getName(), (Object)name);
                it.remove();
                continue;
            }
            Class<?> attrType = AnnotationUtils.getAttributeType(annotationType, name);
            Validate.isTrue((boolean)ClassUtils.isAssignable(value.getClass(), attrType), (String)"Attribute '%s' expects %s, but given: %s (%s)", (Object[])new Object[]{name, attrType.getName(), value, value.getClass().getName()});
        }
        Method[] methodArray = annotationType.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Validate.isTrue((attributes.containsKey(m.getName()) || m.getDefaultValue() != null ? 1 : 0) != 0, (String)"Missing required attribute: %s", (Object[])new Object[]{m.getName()});
            ++n2;
        }
        AnnotationDescriptor descriptor = AnnotationDescriptor.getInstance(annotationType, attributes);
        return (T)AnnotationFactory.create((AnnotationDescriptor)descriptor);
    }

    private static Object invokeNonArgMethod(Object object, String methodName) {
        Class<?> clazz = object.getClass();
        try {
            return clazz.getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(String.format("Class should declare method %s()", methodName), ex);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

