/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import blue.hive.exception.BHiveInvalidFormatException;
import blue.hive.util.anyframe.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class BHiveDateUtil {
    public static DateTime parseToDateTime(String dateString) {
        return BHiveDateUtil.parseToDateTime(dateString, true);
    }

    public static DateTime parseToDateTime(String dateString, Boolean throwException) {
        if (StringUtil.isEmptyTrimmed(dateString)) {
            return null;
        }
        DateTimeFormatter dateFormatter = null;
        if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        } else if (dateString.matches("^\\d{4}/\\d{2}/\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
        } else if (dateString.matches("^\\d{8}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        } else if (dateString.matches("^\\d{4}\\d{2}\\d{2}\\d{2}\\d{2}\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
        } else if (dateString.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        } else if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\x2E\\d{3}[+-]{1}\\d{2}:\\d{2}$")) {
            dateFormatter = ISODateTimeFormat.dateTime();
        } else {
            if (throwException.booleanValue()) {
                throw new BHiveInvalidFormatException("Invalid DateTime Format. ['" + dateString + "']");
            }
            return null;
        }
        return dateFormatter.parseDateTime(dateString);
    }

    public static LocalDateTime parseToLocalDateTime(String dateString) {
        return BHiveDateUtil.parseToLocalDateTime(dateString, true);
    }

    public static LocalDateTime parseToLocalDateTime(String dateString, Boolean throwException) {
        if (StringUtil.isEmptyTrimmed(dateString)) {
            return null;
        }
        DateTimeFormatter dateFormatter = null;
        if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        } else if (dateString.matches("^\\d{4}/\\d{2}/\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
        } else if (dateString.matches("^\\d{8}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        } else if (dateString.matches("^\\d{4}\\d{2}\\d{2}\\d{2}\\d{2}\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
        } else if (dateString.matches("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$")) {
            dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        } else if (dateString.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\x2E\\d{3}$")) {
            dateFormatter = ISODateTimeFormat.dateHourMinuteSecondMillis();
        } else {
            if (throwException.booleanValue()) {
                throw new BHiveInvalidFormatException("Invalid DateTime Format. ['" + dateString + "']");
            }
            return null;
        }
        return dateFormatter.parseLocalDateTime(dateString);
    }

    public static LocalDateTime parseToLocalDateTime(String dateString, String format) {
        if (StringUtil.isEmptyTrimmed(dateString)) {
            return null;
        }
        DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)format);
        return dateFormatter.parseLocalDateTime(dateString);
    }

    public static String formatDate(Date date, String formatString) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatString);
        return formatter.format(date);
    }

    public static String yyyyMMdd(Date date) {
        return BHiveDateUtil.formatDate(date, "yyyyMMdd");
    }

    public static String yyyyMMddHHmmss(Date date) {
        return BHiveDateUtil.formatDate(date, "yyyyMMddHHmmss");
    }

    public static String yyyyMMddHHmmssSSSS(Date date) {
        return BHiveDateUtil.formatDate(date, "yyyyMMddHHmmssSSSS");
    }

    public static String formatNowDate(String formatString) {
        return BHiveDateUtil.formatDate(new Date(), formatString);
    }

    public static String yyyy() {
        return BHiveDateUtil.formatNowDate("yyyy");
    }

    public static String yyyyMM() {
        return BHiveDateUtil.formatNowDate("yyyyMM");
    }

    public static String yyyyMMdd() {
        return BHiveDateUtil.formatNowDate("yyyyMMdd");
    }

    public static String yyyyMMddHHmmss() {
        return BHiveDateUtil.formatNowDate("yyyyMMddHHmmss");
    }

    public static String yyyyMMddHHmmssSSSS() {
        return BHiveDateUtil.formatNowDate("yyyyMMddHHmmssSSSS");
    }

    public static String yyyyMMddHypenHHmmss() {
        return BHiveDateUtil.formatNowDate("yyyyMMdd-HHmmss");
    }

    private static Date getDate(int dayAmount) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, dayAmount);
        Date date = cal.getTime();
        return date;
    }

    public static String yyyyMMdd(int dayAmount) {
        return BHiveDateUtil.yyyyMMdd(BHiveDateUtil.getDate(dayAmount));
    }

    public static String convertLocalDateTimeToString(LocalDateTime date) {
        String dateToString = "";
        if (null != date) {
            dateToString = date.toString("yyyy-MM-dd HH:mm:ss");
        }
        return dateToString;
    }

    public static String convertLocalDateTimeToString(LocalDateTime date, String format) {
        String dateToString = "";
        if (null != date) {
            dateToString = date.toString(format);
        }
        return dateToString;
    }

    public static int diffDate(LocalDateTime start, LocalDateTime end) {
        return Days.daysBetween((ReadablePartial)start.toLocalDate(), (ReadablePartial)end.toLocalDate()).getDays();
    }
}

