/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.job;

import blue.hive.exception.BHiveConfigurationException;
import blue.hive.mybatis.support.BHiveSqlSessionDaoSupport;
import blue.hive.spring.core.task.BHiveIntervalCallable;
import blue.hive.spring.core.task.BHiveIntervalTask;
import blue.hive.util.BHiveHostingUtil;
import blue.hive.util.anyframe.StringUtil;
import java.util.HashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;

public class BHiveMyBatisProcedureJob
extends BHiveSqlSessionDaoSupport
implements InitializingBean,
BHiveIntervalCallable {
    protected String instanceNameToRunning;
    private String statement;
    protected TaskExecutor taskExecutor;

    public BHiveMyBatisProcedureJob(String instanceNameToRunning, String statement, TaskExecutor taskExecutor) {
        this.instanceNameToRunning = instanceNameToRunning;
        this.statement = statement;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (StringUtil.isEmpty(this.statement)) {
            throw new BHiveConfigurationException("BHiveMyBatisProcedureJob.statement is required");
        }
        if (this.taskExecutor == null) {
            throw new BHiveConfigurationException("BHiveMyBatisProcedureJob.taskExecutor is required");
        }
    }

    @Override
    public void runIntervalProcessTask() {
        if (this.taskExecutor == null) {
            this.logger.debug("taskExecutor configuration required.");
            return;
        }
        String currentInstanceName = BHiveHostingUtil.getWasContainerName();
        if (!(StringUtil.isEmptyTrimmed(this.instanceNameToRunning) || currentInstanceName != null && this.instanceNameToRunning.equals(currentInstanceName))) {
            this.logger.trace("#### SKIP BATCH #### instanceNameToRunning:{}, currentInstanceName:{}", (Object)this.instanceNameToRunning, (Object)currentInstanceName);
            return;
        }
        this.logger.trace("#### START BATCH #### instanceNameToRunning:{}, currentInstanceName:{}", (Object)this.instanceNameToRunning, (Object)currentInstanceName);
        this.taskExecutor.execute((Runnable)new BHiveIntervalTask(this));
    }

    @Override
    public void doIntervalProcess() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL ===>[" + this.statement + "]");
        }
        HashMap map = new HashMap();
        int res = this.getSqlSession().update(this.statement, map);
        if (res > 0) {
            this.logger.debug("SQL update ===>[" + res + "]");
        }
    }
}

