/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.spring.http.converter;

import blue.hive.crypto.AES256Crypto;
import blue.hive.spring.http.BHiveHttpInputMessage;
import blue.hive.spring.http.BHiveHttpOutputMessage;
import blue.hive.spring.http.BHiveTeeHttpInputMessage;
import blue.hive.spring.http.BHiveTeeHttpOutputMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class BHiveSecuredHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    AES256Crypto crypto;
    HttpMessageConverter<T> httpConverter = null;

    public BHiveSecuredHttpMessageConverter(AES256Crypto crypto, HttpMessageConverter<T> httpConverter) {
        if (crypto == null || httpConverter == null) {
            throw new IllegalArgumentException("crypto, httpConverter parameters cannot be null.");
        }
        this.crypto = crypto;
        this.httpConverter = httpConverter;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.httpConverter.canRead(clazz, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.httpConverter.canWrite(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.httpConverter.getSupportedMediaTypes();
    }

    public T read(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        BHiveTeeHttpInputMessage teeHttpInputMessage = new BHiveTeeHttpInputMessage(inputMessage);
        InputStream cis = this.crypto.getDecryptChiperInputStream(teeHttpInputMessage.getBody());
        BHiveHttpInputMessage cryptoInputMessage = new BHiveHttpInputMessage(teeHttpInputMessage, cis);
        BHiveTeeHttpInputMessage teeCryptoHttpInputMessage = new BHiveTeeHttpInputMessage(cryptoInputMessage);
        Object result = this.httpConverter.read(clazz, (HttpInputMessage)teeCryptoHttpInputMessage);
        this.logger.debug("\r\n  >>>> READ: {}\r\n  >>>>       => {}", (Object)teeHttpInputMessage.getTeeInputString(), (Object)teeCryptoHttpInputMessage.getTeeInputString());
        return (T)result;
    }

    public void write(T t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BHiveTeeHttpOutputMessage teeHttpOutputMessage = new BHiveTeeHttpOutputMessage(outputMessage);
        OutputStream cos = this.crypto.getEncryptChiperOutputStream(teeHttpOutputMessage.getBody());
        BHiveHttpOutputMessage cryptoOutputMessage = new BHiveHttpOutputMessage(teeHttpOutputMessage, cos);
        BHiveTeeHttpOutputMessage teeCryptoHttpOutputMessage = new BHiveTeeHttpOutputMessage(cryptoOutputMessage);
        this.httpConverter.write(t, contentType, (HttpOutputMessage)teeCryptoHttpOutputMessage);
        cos.close();
        this.logger.debug("\r\n  >>>> WRITE: {}\r\n  >>>>        => {}", (Object)teeCryptoHttpOutputMessage.getTeeOutputString(), (Object)teeHttpOutputMessage.getTeeOutputString());
    }
}

