/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.servlet.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class BHiveLogMDCInsertingFilter
implements Filter {
    private static final String MDC_ACCESS_IP = "client.accessIP";
    private static final String MDC_ACCESS_IP_PREFIX = "client.accessIP.prefix";
    private static final String MDC_CLIENT_METHOD = "client.httpMethod";

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.insertIntoMDC(request);
            chain.doFilter(request, response);
        }
        finally {
            this.clearMDC();
        }
    }

    private void insertIntoMDC(ServletRequest request) {
        String ipAddress = request.getRemoteAddr();
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String xForwardedFor = httpServletRequest.getHeader("X-FORWARDED-FOR");
            if (xForwardedFor != null && xForwardedFor.length() > 0) {
                ipAddress = xForwardedFor;
            }
            MDC.put((String)MDC_CLIENT_METHOD, (String)httpServletRequest.getMethod());
        }
        if (ipAddress != null && ipAddress.length() > 0) {
            if (ipAddress.equals("0:0:0:0:0:0:0:1")) {
                ipAddress = "127.0.0.1";
            }
            MDC.put((String)MDC_ACCESS_IP, (String)ipAddress);
            MDC.put((String)MDC_ACCESS_IP_PREFIX, (String)this.getClientIPPrefix(ipAddress));
        }
    }

    private String getClientIPPrefix(String ipAddress) {
        if (ipAddress == null || ipAddress.equals("")) {
            return "";
        }
        int posSeperator = ipAddress.indexOf(46);
        if (posSeperator == -1) {
            return "";
        }
        String prefix = ipAddress.substring(0, posSeperator);
        return prefix;
    }

    private void clearMDC() {
        MDC.remove((String)MDC_ACCESS_IP);
        MDC.remove((String)MDC_ACCESS_IP_PREFIX);
        MDC.remove((String)MDC_CLIENT_METHOD);
    }
}

