/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.security.web;

import blue.hive.spring.web.rest.BHiveResponseEntity;
import blue.hive.spring.web.rest.BHiveResponseEntityBuilder;
import blue.hive.util.BHiveUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;

public class BHiveRedirectStrategy
implements RedirectStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean contextRelative;

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String requestUrl = request.getRequestURI();
        String redirectUrl = this.calculateRedirectUrl(request.getContextPath(), url);
        redirectUrl = response.encodeRedirectURL(redirectUrl);
        if (this.isAjaxRequest(request)) {
            BHiveResponseEntity<Object> entity = BHiveResponseEntityBuilder.success().msg("").callback(BHiveResponseEntity.REST_CALLBACK_CMD.REDIRECT, redirectUrl).build();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Redirecting Ajax '" + requestUrl + "' to '" + redirectUrl + "'"));
            }
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(BHiveUtil.toJson(entity));
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Redirecting '" + requestUrl + "' to '" + redirectUrl + "'"));
            }
            response.sendRedirect(redirectUrl);
        }
    }

    protected boolean isAjaxRequest(HttpServletRequest request) {
        String xRequestWith;
        return request.getHeader("X-Requested-With") != null && ((xRequestWith = request.getHeader("X-Requested-With").toLowerCase()).indexOf("xmlhttprequest") > -1 || xRequestWith.indexOf("ajax") > -1 || xRequestWith.indexOf("iframe") > -1);
    }

    private String calculateRedirectUrl(String contextPath, String url) {
        if (!UrlUtils.isAbsoluteUrl((String)url)) {
            if (this.contextRelative) {
                return url;
            }
            return contextPath + url;
        }
        if (!this.contextRelative) {
            return url;
        }
        url = url.substring(url.lastIndexOf("://") + 3);
        if ((url = url.substring(url.indexOf(contextPath) + contextPath.length())).length() > 1 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    public void setContextRelative(boolean useRelativeContext) {
        this.contextRelative = useRelativeContext;
    }
}

