/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class InvokeOnPartitions {
    public static final int TRY_COUNT = 10;
    public static final int TRY_PAUSE_MILLIS = 300;
    private OperationServiceImpl operationService;
    private final String serviceName;
    private final OperationFactory operationFactory;
    private final Map<Address, List<Integer>> memberPartitions;
    private final Map<Address, Future> futures;
    private final Map<Integer, Object> partitionResults;

    InvokeOnPartitions(OperationServiceImpl operationService, String serviceName, OperationFactory operationFactory, Map<Address, List<Integer>> memberPartitions) {
        this.operationService = operationService;
        this.serviceName = serviceName;
        this.operationFactory = operationFactory;
        this.memberPartitions = memberPartitions;
        this.futures = new HashMap<Address, Future>(memberPartitions.size());
        int partitionCount = operationService.nodeEngine.getPartitionService().getPartitionCount();
        this.partitionResults = new HashMap<Integer, Object>(partitionCount);
    }

    Map<Integer, Object> invoke() throws Exception {
        this.ensureNotCallingFromOperationThread();
        this.invokeOnAllPartitions();
        this.awaitCompletion();
        this.retryFailedPartitions();
        return this.partitionResults;
    }

    private void ensureNotCallingFromOperationThread() {
        if (this.operationService.operationExecutor.isOperationThread()) {
            throw new IllegalThreadStateException(Thread.currentThread() + " cannot make invocation on multiple partitions!");
        }
    }

    private void invokeOnAllPartitions() {
        for (Map.Entry<Address, List<Integer>> mp : this.memberPartitions.entrySet()) {
            Address address = mp.getKey();
            List<Integer> partitions = mp.getValue();
            PartitionIteratingOperation pi = new PartitionIteratingOperation(partitions, this.operationFactory);
            InternalCompletableFuture future = this.operationService.createInvocationBuilder(this.serviceName, (Operation)pi, address).setTryCount(10).setTryPauseMillis(300L).invoke();
            this.futures.put(address, future);
        }
    }

    private void awaitCompletion() {
        NodeEngineImpl nodeEngine = this.operationService.nodeEngine;
        for (Map.Entry<Address, Future> response : this.futures.entrySet()) {
            try {
                Future future = response.getValue();
                PartitionIteratingOperation.PartitionResponse result = (PartitionIteratingOperation.PartitionResponse)nodeEngine.toObject(future.get());
                this.partitionResults.putAll(result.asMap());
            }
            catch (Throwable t) {
                if (this.operationService.logger.isFinestEnabled()) {
                    this.operationService.logger.finest(t);
                } else {
                    this.operationService.logger.warning(t.getMessage());
                }
                List<Integer> partitions = this.memberPartitions.get(response.getKey());
                for (Integer partition : partitions) {
                    this.partitionResults.put(partition, t);
                }
            }
        }
    }

    private void retryFailedPartitions() throws InterruptedException, ExecutionException {
        Object result;
        LinkedList<Integer> failedPartitions = new LinkedList<Integer>();
        for (Map.Entry<Integer, Object> partitionResult : this.partitionResults.entrySet()) {
            int partitionId = partitionResult.getKey();
            result = partitionResult.getValue();
            if (!(result instanceof Throwable)) continue;
            failedPartitions.add(partitionId);
        }
        for (Integer failedPartition : failedPartitions) {
            InternalCompletableFuture f = this.operationService.createInvocationBuilder(this.serviceName, this.operationFactory.createOperation(), failedPartition).invoke();
            this.partitionResults.put(failedPartition, f);
        }
        for (Integer failedPartition : failedPartitions) {
            Future f = (Future)this.partitionResults.get(failedPartition);
            result = f.get();
            this.partitionResults.put(failedPartition, result);
        }
    }
}

