/*
 * Decompiled with CFR 0.152.
 */
package blue.hive.util;

import blue.hive.util.anyframe.StringUtil;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHiveStringUtil {
    private static final Logger logger = LoggerFactory.getLogger(BHiveStringUtil.class);

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String htmlEscapeExcludeBR(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        return StringUtil.htmlEscape(text.replace("\n", "<br/>\n")).replace("&lt;br/&gt;", "<br/>");
    }

    public static boolean isPatternUpperCaseInclude(String str) {
        Pattern p = Pattern.compile(".*[A-Z].*", 64);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isPatternLowerCaseInclude(String str) {
        Pattern p = Pattern.compile(".*[a-z].*", 64);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean validateBadSequenceLength(String pw, Integer badSequenceLength) {
        if (badSequenceLength == null) {
            badSequenceLength = 2;
        }
        String numbers = "01234567890";
        int start = badSequenceLength;
        String seq = "_" + pw.substring(0, start);
        for (int i = start; i < pw.length(); ++i) {
            seq = seq.substring(1) + pw.charAt(i);
            logger.debug("seq: {}", (Object)seq);
            if (numbers.indexOf(seq) > -1) {
                logger.debug("sequencial pw invalid.");
                return false;
            }
            if (!seq.replace(seq.substring(0, 1), "").equals("")) continue;
            logger.debug("equivalant pw invalid.");
            return false;
        }
        return true;
    }
}

