/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.pigeonpost.localbroadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import org.dmfs.pigeonpost.Cage;
import org.dmfs.pigeonpost.Dovecote;
import org.dmfs.pigeonpost.localbroadcast.ParcelableCage;
import org.dmfs.pigeonpost.localbroadcast.tools.MainThreadExecutor;

public final class ParcelableDovecote<T extends Parcelable>
implements Dovecote<T> {
    private final Context mContext;
    private final String mName;
    private final BroadcastReceiver mReceiver;

    public ParcelableDovecote(@NonNull Context context, @NonNull String name, @NonNull Dovecote.OnPigeonReturnCallback<T> callback) {
        this.mContext = context;
        this.mName = name;
        this.mReceiver = new DovecotReceiver(callback);
        LocalBroadcastManager.getInstance((Context)context).registerReceiver(this.mReceiver, new IntentFilter(this.mName));
    }

    @NonNull
    public Cage<T> cage() {
        return new ParcelableCage(new Intent(this.mName));
    }

    public void dispose() {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(this.mReceiver);
    }

    private static class DovecotReceiver<T extends Parcelable>
    extends BroadcastReceiver {
        private final Dovecote.OnPigeonReturnCallback<T> mCallback;

        private DovecotReceiver(@NonNull Dovecote.OnPigeonReturnCallback<T> callback) {
            this.mCallback = callback;
        }

        public void onReceive(Context context, final Intent intent) {
            MainThreadExecutor.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    DovecotReceiver.this.mCallback.onPigeonReturn((Object)intent.getParcelableExtra("org.dmfs.pigeonpost.DATA"));
                }
            });
        }
    }
}

