/*
 * Decompiled with CFR 0.152.
 */
package com.dmallcott.dismissibleimageview.blur_transformation;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.renderscript.RSRuntimeException;
import com.dmallcott.dismissibleimageview.blur_transformation.FastBlur;
import com.dmallcott.dismissibleimageview.blur_transformation.RsBlur;
import com.squareup.picasso.Transformation;

public class BlurTransformation
implements Transformation {
    private static int MAX_RADIUS = 25;
    private static int DEFAULT_DOWN_SAMPLING = 1;
    private Context mContext;
    private int mRadius;
    private int mSampling;

    public BlurTransformation(Context context) {
        this(context, MAX_RADIUS, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, int radius) {
        this(context, radius, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, int radius, int sampling) {
        this.mContext = context.getApplicationContext();
        this.mRadius = radius;
        this.mSampling = sampling;
    }

    public Bitmap transform(Bitmap source) {
        int scaledWidth = source.getWidth() / this.mSampling;
        int scaledHeight = source.getHeight() / this.mSampling;
        Bitmap bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mSampling, 1.0f / (float)this.mSampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                bitmap = RsBlur.blur(this.mContext, bitmap, this.mRadius);
            }
            catch (RSRuntimeException e) {
                bitmap = FastBlur.blur(bitmap, this.mRadius, true);
            }
        } else {
            bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        }
        return bitmap;
    }

    public String key() {
        return "BlurTransformation(radius=" + this.mRadius + ", sampling=" + this.mSampling + ")";
    }
}

