/*
 * Decompiled with CFR 0.152.
 */
package com.dmallcott.dismissibleimageview;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.dmallcott.dismissibleimageview.DismissibleDragShadowBuilder;
import com.dmallcott.dismissibleimageview.DismissibleOnDragListener;
import com.dmallcott.dismissibleimageview.R;
import com.dmallcott.dismissibleimageview.blur_transformation.BlurTransformation;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;
import java.util.ArrayList;

public class FullScreenImageFragment
extends DialogFragment {
    private ImageView imageView;
    private View topBorderView;
    private View bottomBorderView;
    private View leftBorderView;
    private View rightBorderView;
    private static final String ARGUMENT_URL = "ARGUMENT_URL";
    private static final String ARGUMENT_LOADING_URL = "ARGUMENT_LOADING_URL";
    private static final String ARGUMENT_BITMAP = "ARGUMENT_BITMAP";
    private static final String ARGUMENT_LOADING_BITMAP = "ARGUMENT_LOADING_BITMAP";
    private static final String ARGUMENT_LOADING_BLUR = "ARGUMENT_LOADING_BLUR";

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        LayoutInflater layoutInflater = (LayoutInflater)this.getActivity().getSystemService("layout_inflater");
        View view = layoutInflater.inflate(R.layout.fragment_full_screen_image, null);
        try {
            dialog.getWindow().requestFeature(1);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.initialiseViews(view);
        this.handleArguments(savedInstanceState != null ? savedInstanceState : this.getArguments());
        dialog.setContentView(view);
        return dialog;
    }

    public void onActivityCreated(Bundle arg0) {
        super.onActivityCreated(arg0);
        if (this.getDialog() != null) {
            this.getDialog().getWindow().getAttributes().windowAnimations = R.style.DialogAnimation;
        }
    }

    public void onStart() {
        super.onStart();
        if (this.getDialog() != null) {
            this.getDialog().getWindow().setLayout(-1, -1);
            this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Drawable drawable = this.imageView.getDrawable();
        if (drawable instanceof BitmapDrawable) {
            outState.putParcelable(ARGUMENT_BITMAP, (Parcelable)Bitmap.createBitmap((Bitmap)((BitmapDrawable)drawable).getBitmap()));
        }
    }

    public void show(@NonNull FragmentManager fragmentManager) {
        this.show(fragmentManager, "FullScreenImageFragment");
    }

    private void initialiseViews(final @NonNull View view) {
        this.imageView = (ImageView)view.findViewById(R.id.fragment_full_screen_imageView);
        this.topBorderView = view.findViewById(R.id.fragment_full_screen_top_border);
        this.bottomBorderView = view.findViewById(R.id.fragment_full_screen_bottom_border);
        this.leftBorderView = view.findViewById(R.id.fragment_full_screen_left_border);
        this.rightBorderView = view.findViewById(R.id.fragment_full_screen_right_border);
        this.leftBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(x / (float)FullScreenImageFragment.this.leftBorderView.getWidth());
            }
        }));
        this.rightBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(1.0f - x / (float)FullScreenImageFragment.this.rightBorderView.getWidth());
            }
        }));
        this.topBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(y / (float)FullScreenImageFragment.this.topBorderView.getHeight());
            }
        }));
        this.bottomBorderView.setOnDragListener((View.OnDragListener)new DismissibleOnDragListener(new DismissibleOnDragListener.OnDropListener(){

            @Override
            void onDragStarted() {
                FullScreenImageFragment.this.imageView.setVisibility(4);
            }

            @Override
            public void onDrop() {
                FullScreenImageFragment.this.dismiss();
            }

            @Override
            void onDragEnded() {
                FullScreenImageFragment.this.imageView.setVisibility(0);
                view.setAlpha(1.0f);
            }

            @Override
            void onDragLocation(float x, float y) {
                view.setAlpha(1.0f - y / (float)FullScreenImageFragment.this.topBorderView.getHeight());
            }
        }));
        this.imageView.setAdjustViewBounds(true);
        this.imageView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        Point offset = new Point((int)event.getX(), (int)event.getY());
                        DismissibleDragShadowBuilder shadowBuilder = new DismissibleDragShadowBuilder(FullScreenImageFragment.this.imageView, offset);
                        FullScreenImageFragment.this.imageView.startDrag(null, (View.DragShadowBuilder)shadowBuilder, (Object)FullScreenImageFragment.this.imageView, 0);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private void handleArguments(@NonNull Bundle bundle) {
        Bitmap bitmap = (Bitmap)bundle.getParcelable(ARGUMENT_BITMAP);
        Bitmap loadingBitmap = (Bitmap)bundle.getParcelable(ARGUMENT_LOADING_BITMAP);
        String url = bundle.getString(ARGUMENT_URL);
        String loadingUrl = bundle.getString(ARGUMENT_LOADING_URL);
        boolean loadingBlur = bundle.getBoolean(ARGUMENT_LOADING_BLUR);
        if (bitmap != null) {
            this.loadBitmap(bitmap);
        } else if (!TextUtils.isEmpty((CharSequence)url)) {
            if (loadingBitmap != null) {
                this.loadLoadingBitmap(loadingBitmap, url, loadingBlur);
            } else if (!TextUtils.isEmpty((CharSequence)loadingUrl)) {
                this.loadLoadingUrl(url, loadingUrl, loadingBlur);
            }
        }
    }

    private void loadLoadingBitmap(@NonNull Bitmap bitmap, @NonNull String url, boolean loadingBlur) {
        if (loadingBlur) {
            BlurTransformation transformation = new BlurTransformation(this.getContext());
            Bitmap blurredBitmap = transformation.transform(bitmap);
            this.loadUrl(url, blurredBitmap);
        } else {
            this.loadBitmap(bitmap);
        }
    }

    private void loadLoadingUrl(final @NonNull String url, @NonNull String loadingUrl, boolean loadingBlur) {
        ArrayList<BlurTransformation> transformations = new ArrayList<BlurTransformation>();
        if (loadingBlur) {
            transformations.add(new BlurTransformation(this.getContext()));
        }
        Picasso.with((Context)this.getContext()).load(loadingUrl).transform(transformations).into(new Target(){

            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                FullScreenImageFragment.this.loadUrl(url, bitmap);
            }

            public void onBitmapFailed(Drawable errorDrawable) {
            }

            public void onPrepareLoad(Drawable placeHolderDrawable) {
            }
        });
    }

    private void loadUrl(@NonNull String url, @NonNull Bitmap bitmap) {
        this.clearImageView();
        Picasso.with((Context)this.getContext()).load(url).placeholder((Drawable)new BitmapDrawable(this.getResources(), bitmap)).into(this.imageView);
    }

    private void clearImageView() {
        this.imageView.setImageDrawable(null);
    }

    private void loadBitmap(@NonNull Bitmap bitmap) {
        this.clearImageView();
        this.imageView.setImageBitmap(bitmap);
    }

    public static class Builder {
        private String url;
        private String loadingUrl;
        private Bitmap bitmap;
        private Bitmap loadingBitmap;
        private boolean loadingBlur = true;

        public Builder(@NonNull String url) {
            this.url = url;
        }

        public Builder(@NonNull Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        public Builder withLoadingUrl(@NonNull String loadingUrl) {
            this.loadingUrl = loadingUrl;
            return this;
        }

        public Builder withLoadingBitmap(@NonNull Bitmap loadingBitmap) {
            this.loadingBitmap = loadingBitmap;
            return this;
        }

        public Builder withLoadingBlur(boolean loadingBlur) {
            this.loadingBlur = loadingBlur;
            return this;
        }

        public FullScreenImageFragment build() {
            FullScreenImageFragment fragment = new FullScreenImageFragment();
            Bundle bundle = new Bundle();
            if (this.url != null) {
                bundle.putString(FullScreenImageFragment.ARGUMENT_URL, this.url);
            }
            if (this.loadingUrl != null) {
                bundle.putString(FullScreenImageFragment.ARGUMENT_LOADING_URL, this.loadingUrl);
            }
            if (this.bitmap != null) {
                bundle.putParcelable(FullScreenImageFragment.ARGUMENT_BITMAP, (Parcelable)this.bitmap);
            }
            if (this.loadingBitmap != null) {
                bundle.putParcelable(FullScreenImageFragment.ARGUMENT_LOADING_BITMAP, (Parcelable)this.loadingBitmap);
            }
            bundle.putBoolean(FullScreenImageFragment.ARGUMENT_LOADING_BLUR, this.loadingBlur);
            fragment.setArguments(bundle);
            return fragment;
        }
    }
}

