/*
 * Decompiled with CFR 0.152.
 */
package com.dmallcott.dismissibleimageview;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.dmallcott.dismissibleimageview.FullScreenImageFragment;

public class DismissibleImageView
extends AppCompatImageView
implements View.OnClickListener {
    private String finalUrl;
    private boolean blurOnLoading = true;
    @Nullable
    private FragmentManager fragmentManager;

    public DismissibleImageView(Context context) {
        this(context, null);
    }

    public DismissibleImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DismissibleImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOnClickListener(this);
        this.setDrawingCacheEnabled(true);
        this.setAdjustViewBounds(true);
    }

    public void setFinalUrl(@NonNull String url) {
        this.finalUrl = url;
    }

    public void blurOnLoading(boolean blurOnLoading) {
        this.blurOnLoading = blurOnLoading;
    }

    public void setSupportFragmentManager(@NonNull FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    @Deprecated
    public void setOnClickListener(@Nullable View.OnClickListener l) {
        super.setOnClickListener(l);
    }

    @CallSuper
    public void onClick(View v) {
        FragmentManager fragmentManager = null;
        if (this.fragmentManager != null) {
            fragmentManager = this.fragmentManager;
        } else if (this.getContext() instanceof FragmentActivity) {
            fragmentManager = ((AppCompatActivity)this.getContext()).getSupportFragmentManager();
        }
        if (fragmentManager != null) {
            FullScreenImageFragment fragment = TextUtils.isEmpty((CharSequence)this.finalUrl) ? new FullScreenImageFragment.Builder(this.getDrawingCache(true)).withLoadingBlur(this.blurOnLoading).build() : new FullScreenImageFragment.Builder(this.finalUrl).withLoadingBitmap(this.getDrawingCache(true)).withLoadingBlur(this.blurOnLoading).build();
            fragment.show(fragmentManager);
        }
    }
}

