/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.fet;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.annotation.CallSuper;
import java.util.ArrayList;
import java.util.List;
import me.dkzwm.widget.fet.ClearEditText;
import me.dkzwm.widget.fet.R;

public class MaskNumberEditText
extends ClearEditText {
    private static final Object SELECTION_SPAN = new Object();
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private static final String DECIMAL_POINT = ".";
    private static final char DECIMAL_POINT_CHAR = ".".charAt(0);
    private static final String THOUSANDS_SEPARATOR = ",";
    private static final char THOUSANDS_SEPARATOR_CHAR = ",".charAt(0);
    private static final String ZERO_PLACEHOLDER = "0";
    private static final char ZERO_PLACEHOLDER_CHAR = "0".charAt(0);
    private boolean mIsFormatted = false;
    private List<TextWatcher> mWatchers;
    private MaskNumberTextWatcher mTextWatcher;
    private boolean mRestoring = false;
    private boolean mFilterRestoreTextChangeEvent = false;
    private String mCurrencySymbol;
    private int mCurrencySymbolTextColor = -1;
    private int mDecimalLength = -1;
    private double mMaxNumberValue = -1.0;
    private boolean mAutoFillNumbers = false;
    private int mAutoFillNumbersTextColor = -1;
    private boolean mShowThousandsSeparator = true;

    public MaskNumberEditText(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public MaskNumberEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public MaskNumberEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        Editable text;
        this.mTextWatcher = new MaskNumberTextWatcher();
        super.addTextChangedListener((TextWatcher)this.mTextWatcher);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MaskNumberEditText, defStyleAttr, 0);
            try {
                this.setCurrencySymbol(ta.getString(R.styleable.MaskNumberEditText_fet_currencySymbol));
                this.setCurrencySymbolTextColor(ta.getInt(R.styleable.MaskNumberEditText_fet_currencySymbolTextColor, -1));
                this.setDecimalLength(ta.getInt(R.styleable.MaskNumberEditText_fet_decimalLength, -1));
                this.setAutoFillNumbers(ta.getBoolean(R.styleable.MaskNumberEditText_fet_autoFillNumbers, false));
                this.setAutoFillNumbersTextColor(ta.getInt(R.styleable.MaskNumberEditText_fet_autoFillNumbersTextColor, -1));
                this.setShowThousandsSeparator(ta.getBoolean(R.styleable.MaskNumberEditText_fet_showThousandsSeparator, true));
                String maxValue = ta.getString(R.styleable.MaskNumberEditText_fet_maxNumberValue);
                if (maxValue != null) {
                    try {
                        double max = Double.parseDouble(maxValue);
                        this.setMaxNumberValue(max);
                    }
                    catch (NumberFormatException e) {
                        Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"The value of attribute fet_maxNumberValue is not a Double");
                    }
                }
            }
            finally {
                ta.recycle();
            }
        }
        if ((text = this.getText()) == null || text.length() == 0) {
            if (this.mAutoFillNumbers || this.mCurrencySymbol != null) {
                this.setText("");
            }
            return;
        }
        this.formatEditable(text);
        Selection.setSelection((Spannable)text, (int)text.length());
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mWatchers == null) {
            this.mWatchers = new ArrayList<TextWatcher>();
        }
        this.mWatchers.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        if (this.mWatchers != null) {
            this.mWatchers.remove(watcher);
        }
    }

    @CallSuper
    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filters can not be null");
        }
        boolean havingFilter = false;
        for (InputFilter filter : filters) {
            if (!(filter instanceof MaxNumberValueFilter)) continue;
            havingFilter = true;
            break;
        }
        if (!havingFilter) {
            InputFilter[] replaceFilters = new InputFilter[filters.length + 1];
            replaceFilters[0] = new MaxNumberValueFilter();
            System.arraycopy(filters, 0, replaceFilters, 1, filters.length);
            super.setFilters(replaceFilters);
            return;
        }
        super.setFilters(filters);
    }

    public String getCurrencySymbol() {
        return this.mCurrencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        if (currencySymbol != null && currencySymbol.length() > 1) {
            throw new IllegalArgumentException("currencySymbol must be null or length one character");
        }
        this.mCurrencySymbol = currencySymbol;
    }

    public int getCurrencySymbolTextColor() {
        return this.mCurrencySymbolTextColor;
    }

    public void setCurrencySymbolTextColor(int currencySymbolTextColor) {
        this.mCurrencySymbolTextColor = currencySymbolTextColor;
    }

    public int getDecimalLength() {
        return this.mDecimalLength;
    }

    public void setDecimalLength(int decimalLength) {
        this.mDecimalLength = decimalLength;
    }

    public boolean isAutoFillNumbers() {
        return this.mAutoFillNumbers;
    }

    public void setAutoFillNumbers(boolean autoFillNumbers) {
        this.mAutoFillNumbers = autoFillNumbers;
    }

    public int getAutoFillNumbersTextColor() {
        return this.mAutoFillNumbersTextColor;
    }

    public void setAutoFillNumbersTextColor(int autoFillNumbersTextColor) {
        this.mAutoFillNumbersTextColor = autoFillNumbersTextColor;
    }

    public boolean isShowThousandsSeparator() {
        return this.mShowThousandsSeparator;
    }

    public void setShowThousandsSeparator(boolean showThousandsSeparator) {
        this.mShowThousandsSeparator = showThousandsSeparator;
    }

    public double getMaxNumberValue() {
        return this.mMaxNumberValue;
    }

    public void setMaxNumberValue(double maxNumberValue) {
        if (maxNumberValue < 0.0) {
            throw new IllegalArgumentException("maxNumberValue must be greater than or equal to zero");
        }
        this.mMaxNumberValue = maxNumberValue;
    }

    public String getRealNumber() {
        return this.getRealNumber(false);
    }

    private String getRealNumber(boolean saved) {
        Editable editable = this.getText();
        if (editable == null || editable.length() == 0) {
            return "";
        }
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)editable);
        String number = this.getRealNumber((Editable)builder, saved);
        if (!saved && TextUtils.isEmpty((CharSequence)number)) {
            return ZERO_PLACEHOLDER;
        }
        return number;
    }

    private String getRealNumber(Editable editable, boolean saved) {
        if (editable == null || editable.length() == 0) {
            return "";
        }
        this.clearPlaceholders(editable);
        String realText = editable.toString();
        editable.clear();
        if (!saved && realText.length() > 0) {
            if (realText.charAt(realText.length() - 1) == DECIMAL_POINT_CHAR) {
                return realText.substring(0, realText.length() - 1);
            }
            if (realText.charAt(0) == DECIMAL_POINT_CHAR) {
                return ZERO_PLACEHOLDER + realText;
            }
        }
        return realText;
    }

    private void clearPlaceholders(Editable value) {
        IPlaceholderSpan[] spans;
        for (IPlaceholderSpan span : spans = (IPlaceholderSpan[])value.getSpans(0, value.length(), IPlaceholderSpan.class)) {
            value.delete(value.getSpanStart((Object)span), value.getSpanEnd((Object)span));
        }
    }

    private void sendBeforeTextChanged(CharSequence s, int start, int count, int after) {
        List<TextWatcher> list = this.mWatchers;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).beforeTextChanged(s, start, count, after);
            }
        }
    }

    private void sendOnTextChanged(CharSequence s, int start, int before, int count) {
        List<TextWatcher> list = this.mWatchers;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).onTextChanged(s, start, before, count);
            }
        }
    }

    private void sendAfterTextChanged(Editable s) {
        List<TextWatcher> list = this.mWatchers;
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).afterTextChanged(s);
            }
        }
    }

    private void formatEditable(Editable editable) {
        int selectionEnd;
        int selectionStart;
        this.mIsFormatted = true;
        boolean filter = this.mFilterRestoreTextChangeEvent;
        super.removeTextChangedListener((TextWatcher)this.mTextWatcher);
        InputFilter[] filters = editable.getFilters();
        editable.setFilters(EMPTY_FILTERS);
        if (!filter) {
            selectionStart = Selection.getSelectionStart((CharSequence)editable);
            selectionEnd = Selection.getSelectionEnd((CharSequence)editable);
            editable.setSpan(SELECTION_SPAN, selectionStart, selectionEnd, 17);
        }
        this.formatNumber(editable);
        if (!filter) {
            selectionStart = editable.getSpanStart(SELECTION_SPAN);
            selectionEnd = editable.getSpanEnd(SELECTION_SPAN);
            editable.removeSpan(SELECTION_SPAN);
            editable.setFilters(filters);
            Selection.setSelection((Spannable)editable, (int)Math.min(selectionStart, editable.length()), (int)Math.min(selectionEnd, editable.length()));
        } else {
            editable.setFilters(filters);
        }
        this.mIsFormatted = false;
        super.addTextChangedListener((TextWatcher)this.mTextWatcher);
    }

    private void formatNumber(Editable editable) {
        this.clearPlaceholders(editable);
        DecimalPointSpan[] spans = (DecimalPointSpan[])editable.getSpans(0, editable.length(), DecimalPointSpan.class);
        if (spans.length > 0) {
            ZeroIntegerSpan zeroSpan;
            ZeroIntegerSpan[] zeroSpans;
            int color;
            DecimalPointSpan span = spans[0];
            int start = editable.getSpanStart((Object)span);
            int index = editable.toString().indexOf(DECIMAL_POINT_CHAR);
            if (index != start) {
                editable.delete(start, start + 1);
                span = new DecimalPointSpan(this.getCurrentTextColor());
                editable.setSpan((Object)span, index, index + 1, 33);
            }
            this.formatInteger(editable, editable.getSpanStart((Object)span));
            int decimalPointIndex = editable.getSpanStart((Object)span);
            boolean havingDecimal = this.formatDecimal(editable, decimalPointIndex);
            int spanColor = span.mColor;
            int n = color = havingDecimal ? this.getCurrentTextColor() : this.getFilledTextColorForSpan();
            if (spanColor != color) {
                start = editable.getSpanStart((Object)span);
                editable.removeSpan((Object)span);
                span = new DecimalPointSpan(color);
                editable.setSpan((Object)span, start, start + 1, 33);
            }
            if ((zeroSpans = (ZeroIntegerSpan[])editable.getSpans(0, decimalPointIndex, ZeroIntegerSpan.class)).length > 0 && (spanColor = (zeroSpan = zeroSpans[0]).mColor) != color) {
                start = editable.getSpanStart((Object)zeroSpan);
                editable.removeSpan((Object)zeroSpan);
                zeroSpan = new ZeroIntegerSpan(color);
                editable.setSpan((Object)zeroSpan, start, start + 1, 33);
            }
        } else {
            int index = editable.toString().indexOf(DECIMAL_POINT_CHAR);
            if (index == -1) {
                this.formatInteger(editable, editable.length());
                if (this.mAutoFillNumbers && this.mDecimalLength > 0) {
                    index = editable.length();
                    editable.insert(editable.length(), (CharSequence)DECIMAL_POINT);
                    editable.setSpan((Object)new DecimalPointSpan(this.getFilledTextColorForSpan()), index, index + 1, 33);
                    this.formatDecimal(editable, editable.length());
                }
            } else {
                editable.setSpan((Object)new DecimalPointSpan(this.getCurrentTextColor()), index, index + 1, 33);
                this.formatInteger(editable, index);
                this.formatDecimal(editable, editable.toString().indexOf(DECIMAL_POINT_CHAR));
            }
        }
        this.formatCurrencySymbol(editable);
    }

    private void formatCurrencySymbol(Editable editable) {
        if (this.mCurrencySymbol != null) {
            editable.insert(0, (CharSequence)this.mCurrencySymbol);
            editable.setSpan((Object)new CurrencySymbolSpan(this.mCurrencySymbolTextColor == -1 ? this.getCurrentTextColor() : this.mCurrencySymbolTextColor), 0, 1, 33);
            int start = editable.getSpanStart(SELECTION_SPAN);
            if (start == 0) {
                editable.removeSpan(SELECTION_SPAN);
                editable.setSpan(SELECTION_SPAN, 1, 1, 17);
            }
        }
    }

    private void formatInteger(Editable editable, int decimalPointIndex) {
        int index;
        int position = 0;
        for (index = decimalPointIndex; index > 0; --index) {
            char integer = editable.charAt(index - 1);
            if (!Character.isDigit(integer)) {
                editable.delete(index - 1, index);
                continue;
            }
            if (position != 0 && position % 3 == 0 && this.mShowThousandsSeparator) {
                editable.insert(index, (CharSequence)THOUSANDS_SEPARATOR);
                editable.setSpan((Object)new ThousandsSeparatorSpan(), index, index + 1, 33);
            }
            ++position;
        }
        if (editable.length() > 0) {
            if (editable.charAt(0) == THOUSANDS_SEPARATOR_CHAR) {
                editable.delete(0, 1);
            } else if (editable.charAt(0) == DECIMAL_POINT_CHAR) {
                editable.insert(0, (CharSequence)ZERO_PLACEHOLDER);
                editable.setSpan((Object)new ZeroIntegerSpan(this.getFilledTextColorForSpan()), 0, 1, 33);
            } else if (editable.charAt(0) == ZERO_PLACEHOLDER_CHAR && editable.length() > 1 && Character.isDigit(editable.charAt(1))) {
                for (index = 1; index < editable.length(); ++index) {
                    char c = editable.charAt(index);
                    if (c == ZERO_PLACEHOLDER_CHAR) continue;
                    if (c != DECIMAL_POINT_CHAR) break;
                    --index;
                    break;
                }
                editable.delete(0, Math.min(index, editable.length() - 1));
            }
        } else if (this.mAutoFillNumbers) {
            editable.insert(0, (CharSequence)ZERO_PLACEHOLDER);
            editable.setSpan((Object)new ZeroIntegerSpan(this.getFilledTextColorForSpan()), 0, 1, 33);
        }
    }

    private boolean formatDecimal(Editable editable, int decimalPointIndex) {
        boolean havingDecimal = false;
        int index = decimalPointIndex + 1;
        while (index < editable.length()) {
            char decimal = editable.charAt(index);
            if (!Character.isDigit(decimal)) {
                editable.delete(index, index + 1);
                continue;
            }
            havingDecimal = true;
            ++index;
        }
        if (this.mDecimalLength >= 0) {
            int decimalLength = editable.length() - 1 - decimalPointIndex;
            if (decimalLength > this.mDecimalLength) {
                editable.delete(decimalPointIndex + 1 + this.mDecimalLength, editable.length());
            } else if (decimalLength < this.mDecimalLength && this.mAutoFillNumbers) {
                int count;
                index = editable.length();
                int n = count = decimalLength <= 0 ? this.mDecimalLength : this.mDecimalLength - decimalLength;
                while (count > 0) {
                    editable.insert(index, (CharSequence)ZERO_PLACEHOLDER);
                    editable.setSpan((Object)new ZeroDecimalSpan(this.getFilledTextColorForSpan()), index, index + 1, 33);
                    --count;
                }
            }
        }
        return havingDecimal && this.mDecimalLength > 0;
    }

    private int getFilledTextColorForSpan() {
        return this.mAutoFillNumbersTextColor == -1 ? this.getCurrentHintTextColor() : this.mAutoFillNumbersTextColor;
    }

    public Parcelable onSaveInstanceState() {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.mCurrencySymbol = this.mCurrencySymbol;
        savedState.mDecimalLength = this.mDecimalLength;
        savedState.mAutoFillNumbersTextColor = this.mAutoFillNumbersTextColor;
        savedState.mAutoFillNumbers = this.mAutoFillNumbers;
        savedState.mShowThousandsSeparator = this.mShowThousandsSeparator;
        savedState.mSelectionStart = start;
        savedState.mSelectionEnd = end;
        savedState.mRealText = this.getRealNumber(true);
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        this.mCurrencySymbol = savedState.mCurrencySymbol;
        this.mDecimalLength = savedState.mDecimalLength;
        this.mAutoFillNumbersTextColor = savedState.mAutoFillNumbersTextColor;
        this.mAutoFillNumbers = savedState.mAutoFillNumbers;
        this.mShowThousandsSeparator = savedState.mShowThousandsSeparator;
        if (savedState.mRealText != null) {
            this.mRestoring = true;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.mRestoring = false;
            this.mFilterRestoreTextChangeEvent = true;
            this.setText(savedState.mRealText);
            this.mFilterRestoreTextChangeEvent = false;
            Editable text = this.getText();
            Selection.setSelection((Spannable)text, (int)Math.min(savedState.mSelectionStart, text.length()), (int)Math.min(savedState.mSelectionEnd, text.length()));
        } else {
            super.onRestoreInstanceState(savedState.getSuperState());
        }
    }

    private class MaskNumberTextWatcher
    implements TextWatcher {
        private MaskNumberTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (MaskNumberEditText.this.mRestoring) {
                return;
            }
            MaskNumberEditText.this.sendBeforeTextChanged(s, start, count, after);
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (MaskNumberEditText.this.mRestoring) {
                return;
            }
            MaskNumberEditText.this.sendOnTextChanged(s, start, before, count);
            if (!MaskNumberEditText.this.mIsFormatted && s instanceof Editable) {
                MaskNumberEditText.this.formatEditable((Editable)s);
            }
        }

        public void afterTextChanged(Editable s) {
            if (MaskNumberEditText.this.mRestoring) {
                return;
            }
            MaskNumberEditText.this.sendAfterTextChanged(s);
        }
    }

    private class MaxNumberValueFilter
    implements InputFilter {
        private SpannableStringBuilder mBuilder;

        private MaxNumberValueFilter() {
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            if (MaskNumberEditText.this.mRestoring || MaskNumberEditText.this.mIsFormatted) {
                return null;
            }
            if (MaskNumberEditText.this.mMaxNumberValue != -1.0) {
                String destString = dest.toString();
                Object[] spans = dest.getSpans(0, dest.length(), Object.class);
                if (this.mBuilder == null) {
                    this.mBuilder = new SpannableStringBuilder();
                }
                this.resetDestSpanned(dest, destString, spans);
                if (dstart - dend != 0) {
                    this.mBuilder.delete(dstart, dend);
                } else {
                    String number = MaskNumberEditText.this.getRealNumber((Editable)this.mBuilder, false);
                    if (this.isLarger(number)) {
                        return "";
                    }
                }
                int endIndex = end;
                for (int i = start; i < end; ++i) {
                    this.resetDestSpanned(dest, destString, spans);
                    this.mBuilder.insert(dstart, source.subSequence(start, i + 1));
                    MaskNumberEditText.this.formatNumber((Editable)this.mBuilder);
                    String number = MaskNumberEditText.this.getRealNumber((Editable)this.mBuilder, false);
                    if (!this.isLarger(number)) continue;
                    endIndex = i;
                    break;
                }
                this.mBuilder.clear();
                return source.subSequence(start, endIndex);
            }
            return null;
        }

        private void resetDestSpanned(Spanned dest, String destString, Object[] spans) {
            this.mBuilder.clear();
            this.mBuilder.append((CharSequence)destString);
            for (Object obj : spans) {
                if (obj instanceof NoCopySpan) continue;
                this.mBuilder.setSpan(obj, dest.getSpanStart(obj), dest.getSpanEnd(obj), dest.getSpanFlags(obj));
            }
        }

        private boolean isLarger(String number) {
            if (TextUtils.isEmpty((CharSequence)number)) {
                return MaskNumberEditText.this.mMaxNumberValue < 0.0;
            }
            try {
                double value = Double.parseDouble(number);
                return MaskNumberEditText.this.mMaxNumberValue < value;
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private String mRealText;
        private String mCurrencySymbol;
        private int mCurrencySymbolTextColor;
        private int mDecimalLength;
        private int mAutoFillNumbersTextColor;
        private boolean mAutoFillNumbers = true;
        private boolean mShowThousandsSeparator = true;
        private int mSelectionStart;
        private int mSelectionEnd;

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mRealText = in.readString();
            this.mCurrencySymbol = in.readString();
            this.mCurrencySymbolTextColor = in.readInt();
            this.mDecimalLength = in.readInt();
            this.mAutoFillNumbersTextColor = in.readInt();
            this.mAutoFillNumbers = in.readInt() != 0;
            this.mShowThousandsSeparator = in.readInt() != 0;
            this.mSelectionStart = in.readInt();
            this.mSelectionEnd = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.mRealText);
            out.writeString(this.mCurrencySymbol);
            out.writeInt(this.mCurrencySymbolTextColor);
            out.writeInt(this.mDecimalLength);
            out.writeInt(this.mAutoFillNumbersTextColor);
            out.writeInt(this.mAutoFillNumbers ? 1 : 0);
            out.writeInt(this.mShowThousandsSeparator ? 1 : 0);
            out.writeInt(this.mSelectionStart);
            out.writeInt(this.mSelectionEnd);
        }
    }

    private static class ZeroDecimalSpan
    extends ForegroundColorSpan
    implements IPlaceholderSpan {
        ZeroDecimalSpan(int color) {
            super(color);
        }
    }

    private static class ZeroIntegerSpan
    extends ForegroundColorSpan
    implements IPlaceholderSpan {
        private final int mColor;

        ZeroIntegerSpan(int color) {
            super(color);
            this.mColor = color;
        }
    }

    private static class ThousandsSeparatorSpan
    implements IPlaceholderSpan {
        private ThousandsSeparatorSpan() {
        }
    }

    private static class CurrencySymbolSpan
    extends ForegroundColorSpan
    implements IPlaceholderSpan {
        CurrencySymbolSpan(int color) {
            super(color);
        }
    }

    private static class DecimalPointSpan
    extends ForegroundColorSpan {
        private final int mColor;

        DecimalPointSpan(int color) {
            super(color);
            this.mColor = color;
        }
    }

    private static interface IPlaceholderSpan {
    }
}

