/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging.interceptors;

import com.dkorobtsov.logging.ClientPrintingExecutor;
import com.dkorobtsov.logging.Level;
import com.dkorobtsov.logging.LoggerConfig;
import com.dkorobtsov.logging.ResponseDetails;
import com.dkorobtsov.logging.TextUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final boolean isDebug;
    private final LoggerConfig loggerConfig;

    public ApacheHttpResponseInterceptor(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
        this.isDebug = loggerConfig.isDebug;
    }

    public void process(HttpResponse response, HttpContext context) throws IOException {
        if (this.isDebug && this.loggerConfig.level != Level.NONE) {
            String subtype = null;
            if (Objects.requireNonNull(response.getEntity()).getContentType() != null) {
                subtype = Objects.requireNonNull(response.getEntity().getContentType()).getValue();
            }
            ResponseDetails responseDetails = ResponseDetails.from(response, TextUtils.isFileRequest(subtype));
            if (TextUtils.isFileRequest(subtype)) {
                ClientPrintingExecutor.printFileResponse(responseDetails, this.loggerConfig);
            } else {
                ClientPrintingExecutor.printJsonResponse(responseDetails, this.loggerConfig);
            }
        }
    }

    public LoggerConfig loggerConfig() {
        return this.loggerConfig;
    }
}

