/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging;

import com.dkorobtsov.logging.LoggerConfig;
import com.dkorobtsov.logging.Printer;
import com.dkorobtsov.logging.ResponseDetails;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Request;

public class ClientPrintingExecutor {
    private static final Logger logger = Logger.getLogger(ClientPrintingExecutor.class.getName());

    private ClientPrintingExecutor() {
    }

    public static void printFileResponse(ResponseDetails responseDetails, LoggerConfig config) {
        ExecutorService executor = (ExecutorService)config.executor;
        if (executor != null) {
            executor.execute(ClientPrintingExecutor.createFileResponseRunnable(config, responseDetails));
            ClientPrintingExecutor.handleThreadTermination(executor);
        } else {
            Printer.printFileResponse(config.logger, config.level, config.maxLineLength, responseDetails);
        }
    }

    public static void printJsonResponse(ResponseDetails responseDetails, LoggerConfig config) {
        ExecutorService executor = (ExecutorService)config.executor;
        if (executor != null) {
            executor.execute(ClientPrintingExecutor.createPrintJsonResponseRunnable(config, responseDetails));
            ClientPrintingExecutor.handleThreadTermination(executor);
        } else {
            Printer.printJsonResponse(config.logger, config.level, config.maxLineLength, responseDetails);
        }
    }

    public static void printFileRequest(Request request, LoggerConfig config) {
        ExecutorService executor = (ExecutorService)config.executor;
        if (executor != null) {
            executor.execute(ClientPrintingExecutor.createFileRequestRunnable(config, request));
            ClientPrintingExecutor.handleThreadTermination(executor);
        } else {
            Printer.printFileRequest(config.logger, config.level, config.maxLineLength, request);
        }
    }

    public static void printJsonRequest(Request request, LoggerConfig config) {
        ExecutorService executor = (ExecutorService)config.executor;
        if (executor != null) {
            executor.execute(ClientPrintingExecutor.createPrintJsonRequestRunnable(config, request));
            ClientPrintingExecutor.handleThreadTermination(executor);
        } else {
            Printer.printJsonRequest(config.logger, config.level, config.maxLineLength, request);
        }
    }

    private static Runnable createFileResponseRunnable(LoggerConfig config, ResponseDetails responseDetails) {
        return () -> Printer.printFileResponse(config.logger, config.level, config.maxLineLength, responseDetails);
    }

    private static Runnable createPrintJsonResponseRunnable(LoggerConfig config, ResponseDetails responseDetails) {
        return () -> Printer.printJsonResponse(config.logger, config.level, config.maxLineLength, responseDetails);
    }

    private static Runnable createFileRequestRunnable(LoggerConfig config, Request request) {
        return () -> Printer.printFileRequest(config.logger, config.level, config.maxLineLength, request);
    }

    private static Runnable createPrintJsonRequestRunnable(LoggerConfig config, Request request) {
        return () -> Printer.printJsonRequest(config.logger, config.level, config.maxLineLength, request);
    }

    private static void handleThreadTermination(ExecutorService executor) {
        try {
            executor.awaitTermination(5L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

