/*
 * Decompiled with CFR 0.152.
 */
package com.github.djeang.vincerdom;

import com.github.djeang.vincerdom.VElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class VDocument {
    private final Document w3cDocument;

    private VDocument(Document document) {
        this.w3cDocument = document;
    }

    public static VDocument of(Document document) {
        return new VDocument(document);
    }

    public static VDocument of(String string) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(string);
        document.appendChild(element);
        return new VDocument(document);
    }

    public static VDocument parse(InputStream inputStream, DocumentBuilder documentBuilder) {
        Document document;
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return new VDocument(document);
    }

    public static VDocument parse(InputStream inputStream) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        return VDocument.parse(inputStream, documentBuilder);
    }

    public Document getW3cDocument() {
        return this.w3cDocument;
    }

    public VElement<VDocument> root() {
        Element element = this.w3cDocument.getDocumentElement();
        return VElement.of(this, element);
    }

    public void print(OutputStream outputStream) {
        this.print(outputStream, transformer -> {});
    }

    public void print(OutputStream outputStream, Consumer<Transformer> consumer) {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        consumer.accept(transformer);
        try {
            transformer.transform(new DOMSource(this.w3cDocument), new StreamResult(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
    }
}

