/*
 * Decompiled with CFR 0.152.
 */
package com.github.djeang.vincerdom;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VElement<P> {
    public final P __;
    private Element w3cElement;
    private ElementProxy proxyElement;

    private VElement(P p, Element element) {
        this.__ = p;
        this.w3cElement = element;
    }

    private VElement(P p, VElement vElement, String string) {
        this.__ = p;
        this.proxyElement = ElementProxy.of(vElement, string);
    }

    public static VElement<Void> of(Element element) {
        return new VElement<Object>(null, element);
    }

    public static <P> VElement of(P p, Element element) {
        return new VElement<P>(p, element);
    }

    public Element getW3cElement() {
        return this.w3cElement;
    }

    public VElement<P> attr(String string, String string2) {
        this.assertExist();
        this.w3cElement.setAttribute(string, string2);
        return this;
    }

    public VElement<P> removeAttr(String string) {
        this.assertExist();
        this.w3cElement.removeAttribute(string);
        return this;
    }

    public VElement<P> text(String string) {
        this.assertExist();
        this.w3cElement.setTextContent(string);
        return this;
    }

    public String getText() {
        if (!this.exist()) {
            return null;
        }
        return this.w3cElement.getTextContent();
    }

    public VElement<VElement<P>> add(String string) {
        this.assertExist();
        Element element = this.w3cElement.getOwnerDocument().createElement(string);
        this.w3cElement.appendChild(element);
        return new VElement<VElement<P>>(this, element);
    }

    public VElement<VElement<P>> get(String string) {
        if (!this.exist()) {
            return ElementProxy.of(this, string).create();
        }
        NodeList nodeList = this.w3cElement.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return new VElement<VElement<P>>(this, (Element)nodeList.item(0));
        }
        return new VElement<VElement<P>>(this, this, string);
    }

    public List<VElement> children(String string) {
        if (!this.exist()) {
            return Collections.emptyList();
        }
        LinkedList<VElement<VElement>> linkedList = new LinkedList<VElement<VElement>>();
        NodeList nodeList = this.w3cElement.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            VElement<VElement> vElement = new VElement<VElement>(this, (Element)nodeList.item(i));
            linkedList.add(vElement);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public VElement child(String string) {
        if (!this.exist()) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        NodeList nodeList = this.w3cElement.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return new VElement<VElement>(this, (Element)nodeList.item(0));
    }

    public VElement<P> addSibling(String string) {
        this.assertExist();
        Element element = this.w3cElement.getOwnerDocument().createElement(string);
        this.w3cElement.getParentNode().insertBefore(element, this.w3cElement);
        return VElement.of(this.__, element);
    }

    public VElement<P> remove() {
        this.assertExist();
        this.w3cElement.getParentNode().removeChild(this.w3cElement);
        return this;
    }

    public VElement<P> apply(Consumer<VElement<?>> consumer) {
        this.assertExist();
        consumer.accept(this);
        return this;
    }

    public boolean exist() {
        return this.w3cElement != null;
    }

    public VElement<P> make() {
        if (!this.exist()) {
            this.w3cElement = this.proxyElement.create().w3cElement;
            this.proxyElement = null;
        }
        return this;
    }

    private void assertExist() {
        if (this.w3cElement == null) {
            throw new IllegalStateException("Element " + this + " does not exist. Please, invoke #make() prior trying to modify it.");
        }
    }

    private String getName() {
        if (this.exist()) {
            return this.w3cElement.getNodeName();
        }
        return this.proxyElement.name;
    }

    public String toString() {
        if (this.__ == null || !(this.__ instanceof VElement)) {
            return this.getName();
        }
        return this.__ + "/" + this.getName();
    }

    private static class ElementProxy {
        private final VElement parent;
        private final String name;

        private ElementProxy(VElement vElement, String string) {
            this.name = string;
            this.parent = vElement;
        }

        static ElementProxy of(VElement vElement, String string) {
            return new ElementProxy(vElement, string);
        }

        VElement create() {
            this.parent.make();
            return this.parent.add(this.name);
        }
    }
}

