/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.views;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import in.co.dipankar.quickandorid.R;

public class PinSecurityView
extends RelativeLayout {
    @Nullable
    private Callback mCallback;
    private Context mContext;
    private View mRootView;
    private View mPinSetupHolder;
    private TextView mPinSetupErrorText;
    private EditText mPinInput;
    private EditText mPinReInput;
    private Button mPinSetupButton;
    private View mPinVerifyHolder;
    private TextView mPinVerifyText;
    private EditText mPinVerifyInput;
    private Button mPinVerifyButton;
    private static String PIN_PREF_KEY = "PIN_PREF_KEY";
    private static String PIN_STRING_KEY = "PIN_STRING_KEY";

    public PinSecurityView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public PinSecurityView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public PinSecurityView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        LayoutInflater mInflater = LayoutInflater.from((Context)context);
        this.mRootView = mInflater.inflate(R.layout.view_pin_security, (ViewGroup)this, true);
        this.setVisibility(8);
        this.mPinSetupHolder = this.mRootView.findViewById(R.id.pin_setup_holder);
        this.mPinSetupErrorText = (TextView)this.mRootView.findViewById(R.id.pin_setup_error_text);
        this.mPinInput = (EditText)this.mRootView.findViewById(R.id.pin_setup_input);
        this.mPinReInput = (EditText)this.mRootView.findViewById(R.id.pin_setup_reinput);
        this.mPinSetupButton = (Button)this.mRootView.findViewById(R.id.pin_setup_button);
        this.mPinVerifyHolder = this.mRootView.findViewById(R.id.pin_verify_holder);
        this.mPinVerifyText = (TextView)this.mRootView.findViewById(R.id.pin_verify_error_text);
        this.mPinVerifyInput = (EditText)this.mRootView.findViewById(R.id.pin_verify_input);
        this.mPinVerifyButton = (Button)this.mRootView.findViewById(R.id.pin_verify_button);
        this.mPinSetupButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PinSecurityView.this.savePin(PinSecurityView.this.mPinReInput.getText().toString());
                if (PinSecurityView.this.mCallback != null) {
                    PinSecurityView.this.mCallback.onPinSetupSuccess();
                }
            }
        });
        this.mPinReInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                String secondPin;
                String firstPin = PinSecurityView.this.mPinInput.getText().toString();
                if (!firstPin.equals(secondPin = PinSecurityView.this.mPinReInput.getText().toString())) {
                    PinSecurityView.this.mPinSetupErrorText.setText((CharSequence)"Pin mismatch");
                    PinSecurityView.this.mPinSetupErrorText.setVisibility(0);
                    PinSecurityView.this.mPinSetupButton.setEnabled(false);
                } else {
                    PinSecurityView.this.mPinSetupErrorText.setVisibility(8);
                    PinSecurityView.this.mPinSetupButton.setEnabled(true);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.mPinVerifyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PinSecurityView.this.verifyPin(PinSecurityView.this.mPinReInput.getText().toString());
            }
        });
        this.showPinScreen();
    }

    private void savePin(String pin) {
        SharedPreferences prefs = this.mContext.getSharedPreferences(PIN_PREF_KEY, 0);
        prefs.edit().putString(PIN_STRING_KEY, pin).apply();
    }

    private void verifyPin(String pin) {
        SharedPreferences prefs = this.mContext.getSharedPreferences(PIN_PREF_KEY, 0);
        String savedPin = prefs.getString(PIN_STRING_KEY, "");
        if (savedPin != null && pin.equals(savedPin)) {
            if (this.mCallback != null) {
                this.mCallback.onPinVerifySuccess();
            }
        } else {
            this.mPinVerifyText.setText((CharSequence)"Wrong Pin. Please retry!");
            if (this.mCallback != null) {
                this.mCallback.onPinVerifyError();
            }
        }
    }

    public void showPinScreen() {
        SharedPreferences prefs = this.mContext.getSharedPreferences(PIN_PREF_KEY, 0);
        String savedPin = prefs.getString(PIN_STRING_KEY, null);
        if (savedPin == null) {
            this.showPinSetupScreen();
        } else {
            this.showPinVerifyScreen();
        }
    }

    private void showPinSetupScreen() {
        this.mPinSetupHolder.setVisibility(0);
        this.mPinVerifyHolder.setVisibility(8);
        this.setVisibility(0);
    }

    private void showPinVerifyScreen() {
        this.mPinSetupHolder.setVisibility(8);
        this.mPinVerifyHolder.setVisibility(0);
        this.setVisibility(0);
    }

    public static interface Callback {
        public void onPinSetupSuccess();

        public void onPinSetupError();

        public void onPinVerifySuccess();

        public void onPinVerifyError();
    }
}

