/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import in.co.dipankar.quickandorid.utils.AndroidUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class TelemetryUtils {
    private Context mContext;
    private Callback mCallback;
    private String mUrl;
    private boolean mDebug;
    OkHttpClient mHttpclient;
    private static final String s_session = TelemetryUtils.getSaltString();
    private final String TAG = "DIPANKAR";

    public TelemetryUtils(Context context, String url, boolean isForce, Callback callback) {
        this.mContext = context;
        this.mUrl = url;
        this.mCallback = callback;
        AndroidUtils.Get();
        this.mDebug = AndroidUtils.isDebug();
        if (isForce) {
            this.mDebug = false;
        }
        this.initInternal();
    }

    public void markHit(String tag) {
        this.sendTelemetry(tag, null);
    }

    public void sendTelemetry(String tag, Map<String, String> map) {
        if (this.mHttpclient == null || this.mUrl == null) {
            Log.d((String)"DIPANKAR", (String)"You must need to call setup() first.");
            return;
        }
        if (this.mDebug) {
            Log.d((String)"DIPANKAR", (String)"Ignore Sending telemetry data as debug build ");
            return;
        }
        JSONObject data = new JSONObject();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                data.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.sendTelemtry(tag, data);
    }

    private void initInternal() {
        this.mHttpclient = new OkHttpClient();
        this.sendEventLaunch();
    }

    private void sendTelemtry(String tag, JSONObject json) {
        if (this.mDebug) {
            Log.d((String)"DIPANKAR", (String)"Skipping telemetry as debug build");
            return;
        }
        try {
            json.put("session", (Object)s_session);
            json.put("_cmd", (Object)"insert");
            json.put("_dotserializeinp", true);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SS");
            Calendar cal = Calendar.getInstance();
            String strDate = sdf.format(cal.getTime());
            json.put("timestamp", (Object)strDate);
            json.put("tag", (Object)tag);
            MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json.toString());
            Request request = new Request.Builder().url(this.mUrl).post(body).build();
            this.mHttpclient.newCall(request).enqueue(new com.squareup.okhttp.Callback(){

                public void onFailure(Request request, IOException e) {
                    Log.d((String)"DIPANKAR", (String)("TelemetryUtils: onFailure " + e.toString()));
                    if (TelemetryUtils.this.mCallback != null) {
                        TelemetryUtils.this.mCallback.onFail();
                    }
                }

                public void onResponse(Response response) throws IOException {
                    Log.d((String)"DIPANKAR", (String)("TelemetryUtils: onResponse " + response.toString()));
                    if (TelemetryUtils.this.mCallback != null) {
                        TelemetryUtils.this.mCallback.onSuccess();
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static String getSaltString() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    private void sendEventLaunch() {
        if (this.mDebug) {
            Log.d((String)"DIPANKAR", (String)"Ignore Sending telemetry data as debug build ");
            return;
        }
        JSONObject data = new JSONObject();
        TimeZone tz = TimeZone.getDefault();
        try {
            data.put("_cmd", (Object)"insert");
            data.put("deviceinfo.version", (Object)System.getProperty("os.version"));
            data.put("deviceinfo.version", (Object)System.getProperty("os.version"));
            data.put("deviceinfo.sdk", (Object)Build.VERSION.SDK);
            data.put("deviceinfo.device", (Object)Build.DEVICE);
            data.put("deviceinfo.model", (Object)Build.MODEL);
            data.put("deviceinfo.product", (Object)Build.PRODUCT);
            if (this.mContext != null) {
                data.put("deviceinfo.deviceid", (Object)Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id"));
            }
            data.put("deviceinfo.timezone", (Object)("TimeZone   " + tz.getDisplayName(false, 0) + " Timezon id :: " + tz.getID()));
            this.sendTelemtry("launch", data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Callback {
        public void onSuccess();

        public void onFail();
    }
}

