/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import in.co.dipankar.quickandorid.utils.DLog;

public class RuntimePermissionUtils {
    private static RuntimePermissionUtils instance;
    private Context mContext;
    int mRequestCode = 100;
    CallBack mCallBack;

    public static synchronized RuntimePermissionUtils getInstance() {
        if (instance == null) {
            instance = new RuntimePermissionUtils();
        }
        return instance;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    public void askPermission(String[] pList, CallBack callBack) {
        this.mCallBack = callBack;
        if (Build.VERSION.SDK_INT >= 23) {
            boolean pass = true;
            for (String p : pList) {
                if (this.mContext.checkSelfPermission(p) == 0) continue;
                pass = false;
                break;
            }
            if (pass) {
                this.mCallBack.onSuccess();
            } else {
                ActivityCompat.requestPermissions((Activity)((Activity)this.mContext), (String[])pList, (int)this.mRequestCode);
            }
        } else {
            this.mCallBack.onSuccess();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        boolean pass = true;
        if (requestCode == this.mRequestCode && grantResults.length > 0) {
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] == 0) continue;
                pass = false;
                DLog.d("Failed Because of " + permissions[i]);
            }
            if (pass) {
                this.mCallBack.onSuccess();
            } else {
                this.mCallBack.onFail();
            }
        }
        ++this.mRequestCode;
    }

    private RuntimePermissionUtils() {
    }

    public static interface CallBack {
        public void onSuccess();

        public void onFail();
    }
}

