/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.ContactsContract;
import in.co.dipankar.quickandorid.utils.IPhoneContacts;
import java.util.ArrayList;
import java.util.List;

public class PhoneContactsUtils
implements IPhoneContacts {
    private static final int REQUEST_READ_CONTACTS = 424;
    private Context mContext;
    private Callback mCallback;
    private Handler mUiHandler;

    public PhoneContactsUtils(Context context) {
        this.mContext = context;
        this.mUiHandler = new Handler();
    }

    @Override
    public void getContacts(Callback callback) {
        this.mCallback = callback;
        if (this._mayRequestContacts()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PhoneContactsUtils.this.getContactsInternal();
                }
            }).start();
        } else {
            this.mCallback.onPermissionAsked();
        }
    }

    private void getContactsInternal() {
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        Uri CONTENT_URI = ContactsContract.Contacts.CONTENT_URI;
        String _ID = "_id";
        String DISPLAY_NAME = "display_name";
        String HAS_PHONE_NUMBER = "has_phone_number";
        Uri PhoneCONTENT_URI = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
        String Phone_CONTACT_ID = "contact_id";
        String NUMBER = "data1";
        Uri EmailCONTENT_URI = ContactsContract.CommonDataKinds.Email.CONTENT_URI;
        String EmailCONTACT_ID = "contact_id";
        String DATA = "data1";
        ContentResolver contentResolver = this.mContext.getContentResolver();
        final Cursor cursor = contentResolver.query(CONTENT_URI, null, null, null, null);
        int counter = 0;
        if (cursor.getCount() > 0) {
            while (cursor.moveToNext()) {
                StringBuffer output = new StringBuffer();
                final int counter1 = ++counter;
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PhoneContactsUtils.this.mCallback.onProgress(counter1, cursor.getCount());
                    }
                });
                String id = cursor.getString(cursor.getColumnIndex(_ID));
                String name = cursor.getString(cursor.getColumnIndex(DISPLAY_NAME));
                String phoneNumber = "";
                String email = "";
                int hasPhoneNumber = Integer.parseInt(cursor.getString(cursor.getColumnIndex(HAS_PHONE_NUMBER)));
                if (hasPhoneNumber > 0) {
                    Cursor phoneCursor = contentResolver.query(PhoneCONTENT_URI, null, Phone_CONTACT_ID + " = ?", new String[]{id}, null);
                    while (phoneCursor.moveToNext()) {
                        phoneNumber = phoneNumber + phoneCursor.getString(phoneCursor.getColumnIndex(NUMBER)) + ",";
                    }
                    phoneCursor.close();
                }
                Cursor emailCursor = contentResolver.query(EmailCONTENT_URI, null, EmailCONTACT_ID + " = ?", new String[]{id}, null);
                while (emailCursor.moveToNext()) {
                    email = email + emailCursor.getString(emailCursor.getColumnIndex(DATA)) + ",";
                }
                emailCursor.close();
                contactList.add(new Contact(name, email, phoneNumber));
            }
        }
        final ArrayList<Contact> list1 = contactList;
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                PhoneContactsUtils.this.mCallback.onSuccess(list1);
            }
        });
    }

    private boolean _mayRequestContacts() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return this.mContext.checkSelfPermission("android.permission.READ_CONTACTS") == 0;
    }

    private class Contact
    implements IPhoneContacts.IContact {
        String name;
        String email;
        String phone;

        public Contact(String name, String email, String phoneNumber) {
            this.name = name;
            this.email = email;
            this.phone = phoneNumber;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public String getPhoneNo() {
            return this.phone;
        }
    }

    public static interface Callback {
        public void onPermissionAsked();

        public void onSuccess(List<IPhoneContacts.IContact> var1);

        public void onProgress(int var1, int var2);
    }
}

