/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.utils;

import android.content.Context;
import android.util.Log;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import in.co.dipankar.quickandorid.utils.INetwork;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Network
implements INetwork {
    private static final String TAG = "DIPANKAR::" + Network.class.getSimpleName();
    private static final OkHttpClient mHttpclient = new OkHttpClient();
    private boolean mDebug = false;
    private Context mContext;

    public Network(Context cx, boolean debug) {
        this.mContext = cx;
        this.mDebug = debug;
    }

    @Override
    public void retrive(String url, CacheControl cacheControl, Callback networkCallback) {
        this._retriveInternal(url, cacheControl, networkCallback);
    }

    @Override
    public void send(String url, Map<String, String> data, Callback networkCallback) {
        this._sendInternal(url, data, networkCallback);
    }

    private void _sendInternal(String url, Map<String, String> data, final Callback networkCallback) {
        JSONObject json = new JSONObject();
        try {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                json.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json.toString());
        Request request = new Request.Builder().url(url).post(body).build();
        mHttpclient.newCall(request).enqueue(new com.squareup.okhttp.Callback(){

            public void onFailure(Request request, IOException e) {
                Log.d((String)TAG, (String)("SimpleSend: Failed " + e.toString()));
                if (networkCallback != null) {
                    networkCallback.onError(e.toString());
                }
            }

            public void onResponse(Response response) throws IOException {
                try {
                    String jsonData = response.body().string();
                    JSONObject Jobject = new JSONObject(jsonData);
                    networkCallback.onSuccess(Jobject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    networkCallback.onError("Internal error happened while parsing the json object");
                }
            }
        });
    }

    private void _retriveInternal(final String url, CacheControl cacheControl, final Callback networkCallback) {
        final String key = url.hashCode() + "";
        Request request = new Request.Builder().url(url).build();
        switch (cacheControl) {
            case GET_CACHE_ONLY: {
                JSONObject Jobject = this.readFromCache(key);
                if (Jobject == null) {
                    networkCallback.onError("Cache Not found");
                } else {
                    networkCallback.onSuccess(Jobject);
                }
                return;
            }
            case GET_LIVE_ONLY: {
                Log.d((String)TAG, (String)"Trying fetch from network....");
                mHttpclient.newCall(request).enqueue(new com.squareup.okhttp.Callback(){

                    public void onFailure(Request request, IOException e) {
                        networkCallback.onError("Internal error:" + e.getMessage());
                    }

                    public void onResponse(Response response) throws IOException {
                        try {
                            String jsonData = response.body().string();
                            JSONObject Jobject = new JSONObject(jsonData);
                            networkCallback.onSuccess(Jobject);
                            Network.this.storeInCache(key, Jobject);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            networkCallback.onError("Internal error happened while parsing the json object");
                        }
                    }
                });
                return;
            }
            case GET_CACHE_ELSE_LIVE: {
                JSONObject Jobject = this.readFromCache(key);
                if (Jobject != null) {
                    networkCallback.onSuccess(Jobject);
                } else {
                    this._retriveInternal(url, CacheControl.GET_LIVE_ONLY, networkCallback);
                }
                return;
            }
            case GET_LIVE_ELSE_CACHE: {
                Log.d((String)TAG, (String)"Trying fetch from network....");
                mHttpclient.newCall(request).enqueue(new com.squareup.okhttp.Callback(){

                    public void onFailure(Request request, IOException e) {
                        Network.this._retriveInternal(url, CacheControl.GET_CACHE_ONLY, networkCallback);
                    }

                    public void onResponse(Response response) throws IOException {
                        try {
                            String jsonData = response.body().string();
                            JSONObject Jobject = new JSONObject(jsonData);
                            networkCallback.onSuccess(Jobject);
                            Network.this.storeInCache(key, Jobject);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Network.this._retriveInternal(url, CacheControl.GET_CACHE_ONLY, networkCallback);
                        }
                    }
                });
                return;
            }
        }
    }

    private void storeInCache(String filename, JSONObject data) {
        File cDir = this.mContext.getCacheDir();
        File tempFile = new File(cDir.getPath() + "/" + filename);
        FileWriter writer = null;
        try {
            writer = new FileWriter(tempFile, false);
            writer.write(data.toString());
            writer.close();
            Log.d((String)TAG, (String)("Write successfully to: " + filename));
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"storeInCache Write error");
        }
    }

    private JSONObject readFromCache(String filename) {
        File cDir = this.mContext.getCacheDir();
        File tempFile = new File(cDir.getPath() + "/" + filename);
        String strLine = "";
        StringBuilder text = new StringBuilder();
        try {
            FileReader fReader = new FileReader(tempFile);
            BufferedReader bReader = new BufferedReader(fReader);
            while ((strLine = bReader.readLine()) != null) {
                text.append(strLine + "\n");
            }
            JSONObject x = new JSONObject(text.toString());
            Log.d((String)TAG, (String)("Read succedssfuly from " + filename));
            return x;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"File not found..");
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"Read error occures");
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"Not able to read data as Json is not valid");
        }
        return null;
    }

    public static enum CacheControl {
        GET_CACHE_ELSE_LIVE,
        GET_LIVE_ELSE_CACHE,
        GET_LIVE_ONLY,
        GET_CACHE_ONLY;

    }

    public static interface Callback {
        public void onSuccess(JSONObject var1);

        public void onError(String var1);
    }
}

