/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.TelephonyManager;

public class PhoneStateReceiver
extends BroadcastReceiver {
    Context mContext;
    private Callback mCalback;
    private BroadcastReceiver mBroadcastManager;

    public PhoneStateReceiver() {
    }

    public PhoneStateReceiver(Context context, Callback networkChangeCallback) {
        this.mContext = context;
        this.mCalback = networkChangeCallback;
    }

    public void onReceive(Context context, Intent intent) {
        boolean acCharge;
        if (intent.getAction().equals("android.intent.action.PHONE_STATE")) {
            String state = intent.getStringExtra("state");
            if (state.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                this.mCalback.onCallEnd();
            } else if (state.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                this.mCalback.onIncallingCall();
            } else if (state.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                this.mCalback.onOngoingCall();
            }
        } else if (intent.getAction().equals("android.intent.action.NEW_OUTGOING_CALL")) {
            this.mCalback.onOutgoingCall();
        }
        int status = intent.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        int chargePlug = intent.getIntExtra("plugged", -1);
        boolean usbCharge = chargePlug == 2;
        boolean bl = acCharge = chargePlug == 1;
        if (isCharging || usbCharge || acCharge) {
            this.mCalback.onChargerConnected();
        } else {
            this.mCalback.onChargerDisconnected();
        }
    }

    public void onResume() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.intent.action.BATTERY_LOW");
        intentFilter.addAction("android.intent.action.BATTERY_OKAY");
        intentFilter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        intentFilter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        this.mContext.registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    public void onPause() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
    }

    public static interface Callback {
        public void onIncallingCall();

        public void onOutgoingCall();

        public void onOngoingCall();

        public void onCallEnd();

        public void onIncommingSMS();

        public void onOutgoingSMS();

        public void onChargerConnected();

        public void onChargerDisconnected();

        public void onLowBattery();
    }
}

