/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    Context mContext;
    private Callback mNetworkChangeCallback;
    private BroadcastReceiver mBroadcastManager;

    public NetworkChangeReceiver() {
    }

    public NetworkChangeReceiver(Context context, Callback networkChangeCallback) {
        this.mContext = context;
        this.mNetworkChangeCallback = networkChangeCallback;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mNetworkChangeCallback != null) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (info != null && info.isConnected()) {
                this.mNetworkChangeCallback.onNetworkAvailable();
                if (info.getTypeName().equals("MOBILE")) {
                    this.mNetworkChangeCallback.onNetworkAvailableMobileData();
                } else {
                    this.mNetworkChangeCallback.onNetworkAvailableWifi();
                }
            } else {
                this.mNetworkChangeCallback.onNetworkGone();
            }
        }
    }

    public void onResume() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    public void onPause() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
    }

    public static interface Callback {
        public void onNetworkGone();

        public void onNetworkAvailable();

        public void onNetworkAvailableWifi();

        public void onNetworkAvailableMobileData();
    }
}

