/*
 * Decompiled with CFR 0.152.
 */
package in.co.dipankar.quickandorid.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.AppCompatImageButton;
import android.util.AttributeSet;
import android.view.View;
import in.co.dipankar.quickandorid.R;

public class StateImageButton
extends AppCompatImageButton
implements View.OnClickListener {
    private Drawable enableBack;
    private Drawable disableBack;
    boolean mViewEnable = true;
    private Callback mCallback;

    public StateImageButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public StateImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StateImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mViewEnable = true;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.StateImageButton, 0, 0);
        try {
            this.enableBack = a.getDrawable(R.styleable.StateImageButton_enableBackground);
            this.disableBack = a.getDrawable(R.styleable.StateImageButton_disableBackground);
            this.mViewEnable = a.getBoolean(R.styleable.StateImageButton_is_enable, true);
        }
        finally {
            a.recycle();
        }
        this.setViewEnabled(this.mViewEnable);
        this.setOnClickListener(this);
    }

    public void setViewEnabled(boolean enabled) {
        if (enabled) {
            if (this.enableBack != null) {
                this.setImageDrawable(this.enableBack);
            }
        } else if (this.disableBack != null) {
            this.setImageDrawable(this.disableBack);
        }
        this.mViewEnable = enabled;
    }

    public boolean isViewEnabled() {
        return this.mViewEnable;
    }

    public void setCallBack(Callback callback) {
        this.mCallback = callback;
    }

    public void onClick(View v) {
        this.mViewEnable = !this.mViewEnable;
        this.setViewEnabled(this.mViewEnable);
        if (this.mCallback != null) {
            this.mCallback.click(this.mViewEnable);
        }
    }

    public static interface Callback {
        public void click(boolean var1);
    }
}

