/*
 * Decompiled with CFR 0.152.
 */
package ru.dimorinny.floatingtextbutton.behavior;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import ru.dimorinny.floatingtextbutton.FloatingTextButton;

public class SnackbarBehavior
extends CoordinatorLayout.Behavior<FloatingTextButton> {
    private static final Interpolator HIDE_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final Long HIDE_DURATION = 250L;
    private ViewPropertyAnimatorCompat animation = null;

    public SnackbarBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, FloatingTextButton child, View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FloatingTextButton child, View dependency) {
        if (child.getTranslationY() > 0.0f) {
            return true;
        }
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
        child.setTranslationY(Math.min(0.0f, dependency.getTranslationY() - (float)dependency.getHeight()));
        return true;
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, FloatingTextButton child, View dependency) {
        if (dependency instanceof Snackbar.SnackbarLayout) {
            this.animation = ViewCompat.animate((View)child).translationY(0.0f).setInterpolator(HIDE_INTERPOLATOR).setDuration(HIDE_DURATION.longValue());
            this.animation.start();
        }
        super.onDependentViewRemoved(parent, (View)child, dependency);
    }
}

