/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.DefaultMatcher;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.transform.TransformException;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

public class Transformer {
    private final Cache<Transform> cache = new ConcurrentCache<Transform>();
    private final Cache<Object> error = new ConcurrentCache<Object>();
    private final Matcher matcher;

    public Transformer(Matcher matcher) {
        this.matcher = new DefaultMatcher(matcher);
    }

    public Object read(String string, Class clazz) throws Exception {
        Transform transform = this.lookup(clazz);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", clazz);
        }
        return transform.read(string);
    }

    public String write(Object object, Class clazz) throws Exception {
        Transform transform = this.lookup(clazz);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", clazz);
        }
        return transform.write(object);
    }

    public boolean valid(Class clazz) throws Exception {
        return this.lookup(clazz) != null;
    }

    private Transform lookup(Class clazz) throws Exception {
        if (!this.error.contains(clazz)) {
            Transform transform = this.cache.fetch(clazz);
            if (transform != null) {
                return transform;
            }
            return this.match(clazz);
        }
        return null;
    }

    private Transform match(Class clazz) throws Exception {
        Transform transform = this.matcher.match(clazz);
        if (transform != null) {
            this.cache.cache(clazz, transform);
        } else {
            this.error.cache(clazz, this);
        }
        return transform;
    }
}

