/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.simpleframework.xml.transform.AtomicIntegerTransform;
import org.simpleframework.xml.transform.AtomicLongTransform;
import org.simpleframework.xml.transform.BigDecimalTransform;
import org.simpleframework.xml.transform.BigIntegerTransform;
import org.simpleframework.xml.transform.BooleanTransform;
import org.simpleframework.xml.transform.ByteTransform;
import org.simpleframework.xml.transform.CharacterTransform;
import org.simpleframework.xml.transform.ClassTransform;
import org.simpleframework.xml.transform.CurrencyTransform;
import org.simpleframework.xml.transform.DateTransform;
import org.simpleframework.xml.transform.DoubleTransform;
import org.simpleframework.xml.transform.EnumTransform;
import org.simpleframework.xml.transform.FileTransform;
import org.simpleframework.xml.transform.FloatTransform;
import org.simpleframework.xml.transform.GregorianCalendarTransform;
import org.simpleframework.xml.transform.IntegerTransform;
import org.simpleframework.xml.transform.LocaleTransform;
import org.simpleframework.xml.transform.LongTransform;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.ShortTransform;
import org.simpleframework.xml.transform.StringTransform;
import org.simpleframework.xml.transform.TimeZoneTransform;
import org.simpleframework.xml.transform.Transform;
import org.simpleframework.xml.transform.URLTransform;

class PackageMatcher
implements Matcher {
    @Override
    public Transform match(Class clazz) throws Exception {
        String string = clazz.getName();
        if (string.startsWith("java.lang")) {
            return this.matchLanguage(clazz);
        }
        if (string.startsWith("java.util")) {
            return this.matchUtility(clazz);
        }
        if (string.startsWith("java.net")) {
            return this.matchURL(clazz);
        }
        if (string.startsWith("java.io")) {
            return this.matchFile(clazz);
        }
        if (string.startsWith("java.sql")) {
            return this.matchSQL(clazz);
        }
        if (string.startsWith("java.math")) {
            return this.matchMath(clazz);
        }
        return this.matchEnum(clazz);
    }

    private Transform matchEnum(Class clazz) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            if (clazz2.isEnum()) {
                return new EnumTransform(clazz);
            }
            if (clazz.isEnum()) {
                return new EnumTransform(clazz);
            }
        }
        return null;
    }

    private Transform matchLanguage(Class clazz) throws Exception {
        if (clazz == Boolean.class) {
            return new BooleanTransform();
        }
        if (clazz == Integer.class) {
            return new IntegerTransform();
        }
        if (clazz == Long.class) {
            return new LongTransform();
        }
        if (clazz == Double.class) {
            return new DoubleTransform();
        }
        if (clazz == Float.class) {
            return new FloatTransform();
        }
        if (clazz == Short.class) {
            return new ShortTransform();
        }
        if (clazz == Byte.class) {
            return new ByteTransform();
        }
        if (clazz == Character.class) {
            return new CharacterTransform();
        }
        if (clazz == String.class) {
            return new StringTransform();
        }
        if (clazz == Class.class) {
            return new ClassTransform();
        }
        return null;
    }

    private Transform matchMath(Class clazz) throws Exception {
        if (clazz == BigDecimal.class) {
            return new BigDecimalTransform();
        }
        if (clazz == BigInteger.class) {
            return new BigIntegerTransform();
        }
        return null;
    }

    private Transform matchUtility(Class clazz) throws Exception {
        if (clazz == java.util.Date.class) {
            return new DateTransform(clazz);
        }
        if (clazz == Locale.class) {
            return new LocaleTransform();
        }
        if (clazz == Currency.class) {
            return new CurrencyTransform();
        }
        if (clazz == GregorianCalendar.class) {
            return new GregorianCalendarTransform();
        }
        if (clazz == TimeZone.class) {
            return new TimeZoneTransform();
        }
        if (clazz == AtomicInteger.class) {
            return new AtomicIntegerTransform();
        }
        if (clazz == AtomicLong.class) {
            return new AtomicLongTransform();
        }
        return null;
    }

    private Transform matchSQL(Class clazz) throws Exception {
        if (clazz == Time.class) {
            return new DateTransform(clazz);
        }
        if (clazz == Date.class) {
            return new DateTransform(clazz);
        }
        if (clazz == Timestamp.class) {
            return new DateTransform(clazz);
        }
        return null;
    }

    private Transform matchFile(Class clazz) throws Exception {
        if (clazz == File.class) {
            return new FileTransform();
        }
        return null;
    }

    private Transform matchURL(Class clazz) throws Exception {
        if (clazz == URL.class) {
            return new URLTransform();
        }
        return null;
    }
}

