/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.util.Locale;
import java.util.regex.Pattern;
import org.simpleframework.xml.transform.InvalidFormatException;
import org.simpleframework.xml.transform.Transform;

class LocaleTransform
implements Transform<Locale> {
    private final Pattern pattern = Pattern.compile("_");

    @Override
    public Locale read(String string) throws Exception {
        String[] stringArray = this.pattern.split(string);
        if (stringArray.length < 1) {
            throw new InvalidFormatException("Invalid locale %s", string);
        }
        return this.read(stringArray);
    }

    private Locale read(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"", "", ""};
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i >= stringArray.length) continue;
            stringArray2[i] = stringArray[i];
        }
        return new Locale(stringArray2[0], stringArray2[1], stringArray2[2]);
    }

    @Override
    public String write(Locale locale) {
        return locale.toString();
    }
}

