/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.lang.reflect.Array;
import org.simpleframework.xml.transform.Transform;

class CharacterArrayTransform
implements Transform {
    private final Class entry;

    public CharacterArrayTransform(Class clazz) {
        this.entry = clazz;
    }

    public Object read(String string) throws Exception {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (this.entry == Character.TYPE) {
            return cArray;
        }
        return this.read(cArray, n);
    }

    private Object read(char[] cArray, int n) throws Exception {
        Object object = Array.newInstance(this.entry, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, Character.valueOf(cArray[i]));
        }
        return object;
    }

    public String write(Object object) throws Exception {
        int n = Array.getLength(object);
        if (this.entry == Character.TYPE) {
            char[] cArray = (char[])object;
            return new String(cArray);
        }
        return this.write(object, n);
    }

    private String write(Object object, int n) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null) continue;
            stringBuilder.append(object2);
        }
        return stringBuilder.toString();
    }
}

