/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

abstract class Splitter {
    protected StringBuilder builder = new StringBuilder();
    protected char[] text;
    protected int count;
    protected int off;

    public Splitter(String string) {
        this.text = string.toCharArray();
        this.count = this.text.length;
    }

    public String process() {
        while (this.off < this.count) {
            char c;
            while (this.off < this.count && this.isSpecial(c = this.text[this.off])) {
                ++this.off;
            }
            if (this.acronym()) continue;
            this.token();
            this.number();
        }
        return this.builder.toString();
    }

    private void token() {
        char c;
        int n;
        for (n = this.off; n < this.count && this.isLetter(c = this.text[n]) && (n <= this.off || !this.isUpper(c)); ++n) {
        }
        if (n > this.off) {
            this.parse(this.text, this.off, n - this.off);
            this.commit(this.text, this.off, n - this.off);
        }
        this.off = n;
    }

    private boolean acronym() {
        char c;
        int n;
        int n2 = 0;
        for (n = this.off; n < this.count && this.isUpper(c = this.text[n]); ++n) {
            ++n2;
        }
        if (n2 > 1) {
            if (n < this.count && this.isUpper(c = this.text[n - 1])) {
                --n;
            }
            this.commit(this.text, this.off, n - this.off);
            this.off = n;
        }
        return n2 > 1;
    }

    private boolean number() {
        char c;
        int n;
        int n2 = 0;
        for (n = this.off; n < this.count && this.isDigit(c = this.text[n]); ++n) {
            ++n2;
        }
        if (n2 > 0) {
            this.commit(this.text, this.off, n - this.off);
        }
        this.off = n;
        return n2 > 0;
    }

    private boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    private boolean isSpecial(char c) {
        return !Character.isLetterOrDigit(c);
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean isUpper(char c) {
        return Character.isUpperCase(c);
    }

    protected char toUpper(char c) {
        return Character.toUpperCase(c);
    }

    protected char toLower(char c) {
        return Character.toLowerCase(c);
    }

    protected abstract void parse(char[] var1, int var2, int var3);

    protected abstract void commit(char[] var1, int var2, int var3);
}

