/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import org.simpleframework.xml.stream.EventAttribute;
import org.simpleframework.xml.stream.EventElement;
import org.simpleframework.xml.stream.EventNode;
import org.simpleframework.xml.stream.EventReader;
import org.simpleframework.xml.stream.EventToken;
import org.xmlpull.v1.XmlPullParser;

class PullReader
implements EventReader {
    private XmlPullParser parser;
    private EventNode peek;

    public PullReader(XmlPullParser xmlPullParser) {
        this.parser = xmlPullParser;
    }

    @Override
    public EventNode peek() throws Exception {
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    @Override
    public EventNode next() throws Exception {
        EventNode eventNode = this.peek;
        if (eventNode == null) {
            eventNode = this.read();
        } else {
            this.peek = null;
        }
        return eventNode;
    }

    private EventNode read() throws Exception {
        int n = this.parser.next();
        if (n != 1) {
            if (n == 2) {
                return this.start();
            }
            if (n == 4) {
                return this.text();
            }
            if (n == 3) {
                return this.end();
            }
            return this.read();
        }
        return null;
    }

    private Text text() throws Exception {
        return new Text(this.parser);
    }

    private Start start() throws Exception {
        Start start = new Start(this.parser);
        if (start.isEmpty()) {
            return this.build(start);
        }
        return start;
    }

    private Start build(Start start) throws Exception {
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            Entry entry = this.attribute(i);
            if (entry.isReserved()) continue;
            start.add(entry);
        }
        return start;
    }

    private Entry attribute(int n) throws Exception {
        return new Entry(this.parser, n);
    }

    private End end() throws Exception {
        return new End();
    }

    private static class End
    extends EventToken {
        private End() {
        }

        @Override
        public boolean isEnd() {
            return true;
        }
    }

    private static class Text
    extends EventToken {
        private final XmlPullParser source;
        private final String text;

        public Text(XmlPullParser xmlPullParser) {
            this.text = xmlPullParser.getText();
            this.source = xmlPullParser;
        }

        @Override
        public boolean isText() {
            return true;
        }

        @Override
        public String getValue() {
            return this.text;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class Start
    extends EventElement {
        private final XmlPullParser source;
        private final String reference;
        private final String prefix;
        private final String name;
        private final int line;

        public Start(XmlPullParser xmlPullParser) {
            this.reference = xmlPullParser.getNamespace();
            this.line = xmlPullParser.getLineNumber();
            this.prefix = xmlPullParser.getPrefix();
            this.name = xmlPullParser.getName();
            this.source = xmlPullParser;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getReference() {
            return this.reference;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class Entry
    extends EventAttribute {
        private final XmlPullParser source;
        private final String reference;
        private final String prefix;
        private final String name;
        private final String value;

        public Entry(XmlPullParser xmlPullParser, int n) {
            this.reference = xmlPullParser.getAttributeNamespace(n);
            this.prefix = xmlPullParser.getAttributePrefix(n);
            this.value = xmlPullParser.getAttributeValue(n);
            this.name = xmlPullParser.getAttributeName(n);
            this.source = xmlPullParser;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isReserved() {
            return false;
        }

        @Override
        public String getReference() {
            return this.reference;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }
}

