/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Formatter;
import org.simpleframework.xml.stream.Mode;
import org.simpleframework.xml.stream.NamespaceMap;
import org.simpleframework.xml.stream.NodeException;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputDocument;
import org.simpleframework.xml.stream.OutputElement;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.OutputStack;

class NodeWriter {
    private final OutputStack stack;
    private final Formatter writer;
    private final Set active;
    private final boolean verbose;

    public NodeWriter(Writer writer) {
        this(writer, new Format());
    }

    public NodeWriter(Writer writer, Format format) {
        this(writer, format, false);
    }

    private NodeWriter(Writer writer, Format format, boolean bl) {
        this.writer = new Formatter(writer, format);
        this.active = new HashSet();
        this.stack = new OutputStack(this.active);
        this.verbose = bl;
    }

    public OutputNode writeRoot() throws Exception {
        OutputDocument outputDocument = new OutputDocument(this, this.stack);
        if (this.stack.isEmpty()) {
            this.writer.writeProlog();
        }
        return outputDocument;
    }

    public boolean isRoot(OutputNode outputNode) {
        return this.stack.bottom() == outputNode;
    }

    public boolean isCommitted(OutputNode outputNode) {
        return !this.active.contains(outputNode);
    }

    public void commit(OutputNode outputNode) throws Exception {
        if (this.stack.contains(outputNode)) {
            OutputNode outputNode2 = this.stack.top();
            if (!this.isCommitted(outputNode2)) {
                this.writeStart(outputNode2);
            }
            while (this.stack.top() != outputNode) {
                this.writeEnd(this.stack.pop());
            }
            this.writeEnd(outputNode);
            this.stack.pop();
        }
    }

    public void remove(OutputNode outputNode) throws Exception {
        if (this.stack.top() != outputNode) {
            throw new NodeException("Cannot remove node");
        }
        this.stack.pop();
    }

    public OutputNode writeElement(OutputNode outputNode, String string) throws Exception {
        if (this.stack.isEmpty()) {
            return this.writeStart(outputNode, string);
        }
        if (this.stack.contains(outputNode)) {
            OutputNode outputNode2 = this.stack.top();
            if (!this.isCommitted(outputNode2)) {
                this.writeStart(outputNode2);
            }
            while (this.stack.top() != outputNode) {
                this.writeEnd(this.stack.pop());
            }
            if (!this.stack.isEmpty()) {
                this.writeValue(outputNode);
            }
            return this.writeStart(outputNode, string);
        }
        return null;
    }

    private OutputNode writeStart(OutputNode outputNode, String string) throws Exception {
        OutputElement outputElement = new OutputElement(outputNode, this, string);
        if (string == null) {
            throw new NodeException("Can not have a null name");
        }
        return this.stack.push(outputElement);
    }

    private void writeStart(OutputNode outputNode) throws Exception {
        this.writeComment(outputNode);
        this.writeName(outputNode);
        this.writeAttributes(outputNode);
        this.writeNamespaces(outputNode);
    }

    private void writeComment(OutputNode outputNode) throws Exception {
        String string = outputNode.getComment();
        if (string != null) {
            this.writer.writeComment(string);
        }
    }

    private void writeName(OutputNode outputNode) throws Exception {
        String string = outputNode.getPrefix(this.verbose);
        String string2 = outputNode.getName();
        if (string2 != null) {
            this.writer.writeStart(string2, string);
        }
    }

    private void writeValue(OutputNode outputNode) throws Exception {
        Mode mode = outputNode.getMode();
        String string = outputNode.getValue();
        if (string != null) {
            for (OutputNode outputNode2 : this.stack) {
                if (mode != Mode.INHERIT) break;
                mode = outputNode2.getMode();
            }
            this.writer.writeText(string, mode);
        }
        outputNode.setValue(null);
    }

    private void writeEnd(OutputNode outputNode) throws Exception {
        String string = outputNode.getName();
        String string2 = outputNode.getPrefix(this.verbose);
        String string3 = outputNode.getValue();
        if (string3 != null) {
            this.writeValue(outputNode);
        }
        if (string != null) {
            this.writer.writeEnd(string, string2);
            this.writer.flush();
        }
    }

    private void writeAttributes(OutputNode outputNode) throws Exception {
        NodeMap<OutputNode> nodeMap = outputNode.getAttributes();
        for (String string : nodeMap) {
            OutputNode outputNode2 = nodeMap.get(string);
            String string2 = outputNode2.getValue();
            String string3 = outputNode2.getPrefix(this.verbose);
            this.writer.writeAttribute(string, string2, string3);
        }
        this.active.remove(outputNode);
    }

    private void writeNamespaces(OutputNode outputNode) throws Exception {
        NamespaceMap namespaceMap = outputNode.getNamespaces();
        for (String string : namespaceMap) {
            String string2 = namespaceMap.getPrefix(string);
            this.writer.writeNamespace(string, string2);
        }
    }
}

