/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.strategy;

import java.util.HashMap;
import org.simpleframework.xml.strategy.Allocate;
import org.simpleframework.xml.strategy.ArrayValue;
import org.simpleframework.xml.strategy.Contract;
import org.simpleframework.xml.strategy.CycleException;
import org.simpleframework.xml.strategy.Loader;
import org.simpleframework.xml.strategy.ObjectValue;
import org.simpleframework.xml.strategy.Reference;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.NodeMap;

class ReadGraph
extends HashMap {
    private final Loader loader;
    private final String length;
    private final String label;
    private final String mark;
    private final String refer;

    public ReadGraph(Contract contract, Loader loader) {
        this.refer = contract.getReference();
        this.mark = contract.getIdentity();
        this.length = contract.getLength();
        this.label = contract.getLabel();
        this.loader = loader;
    }

    public Value read(Type type, NodeMap nodeMap) throws Exception {
        Object t = nodeMap.remove(this.label);
        Class clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (t != null) {
            String string = t.getValue();
            clazz = this.loader.load(string);
        }
        return this.readInstance(type, clazz, nodeMap);
    }

    private Value readInstance(Type type, Class clazz, NodeMap nodeMap) throws Exception {
        Object t = nodeMap.remove(this.mark);
        if (t == null) {
            return this.readReference(type, clazz, nodeMap);
        }
        String string = t.getValue();
        if (this.containsKey(string)) {
            throw new CycleException("Element '%s' already exists", string);
        }
        return this.readValue(type, clazz, nodeMap, string);
    }

    private Value readReference(Type type, Class clazz, NodeMap nodeMap) throws Exception {
        Object t = nodeMap.remove(this.refer);
        if (t == null) {
            return this.readValue(type, clazz, nodeMap);
        }
        String string = t.getValue();
        Object v = this.get(string);
        if (!this.containsKey(string)) {
            throw new CycleException("Invalid reference '%s' found", string);
        }
        return new Reference(v, clazz);
    }

    private Value readValue(Type type, Class clazz, NodeMap nodeMap) throws Exception {
        Class clazz2 = type.getType();
        if (clazz2.isArray()) {
            return this.readArray(type, clazz, nodeMap);
        }
        return new ObjectValue(clazz);
    }

    private Value readValue(Type type, Class clazz, NodeMap nodeMap, String string) throws Exception {
        Value value = this.readValue(type, clazz, nodeMap);
        if (string != null) {
            return new Allocate(value, this, string);
        }
        return value;
    }

    private Value readArray(Type type, Class clazz, NodeMap nodeMap) throws Exception {
        Object t = nodeMap.remove(this.length);
        int n = 0;
        if (t != null) {
            String string = t.getValue();
            n = Integer.parseInt(string);
        }
        return new ArrayValue(clazz, n);
    }
}

