/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.PathException;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.Style;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class PathParser
implements Expression {
    protected Cache<String> attributes = new ConcurrentCache<String>();
    protected Cache<String> elements = new ConcurrentCache<String>();
    protected List<Integer> indexes = new ArrayList<Integer>();
    protected List<String> prefixes = new ArrayList<String>();
    protected List<String> names = new ArrayList<String>();
    protected StringBuilder builder = new StringBuilder();
    protected String location;
    protected String cache;
    protected String path;
    protected Style style;
    protected Type type;
    protected boolean attribute;
    protected char[] data;
    protected int count;
    protected int start;
    protected int off;

    public PathParser(String string, Type type, Format format) throws Exception {
        this.style = format.getStyle();
        this.type = type;
        this.path = string;
        this.parse(string);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.location);
    }

    @Override
    public boolean isPath() {
        return this.names.size() > 1;
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public int getIndex() {
        return this.indexes.get(0);
    }

    @Override
    public String getPrefix() {
        return this.prefixes.get(0);
    }

    @Override
    public String getFirst() {
        return this.names.get(0);
    }

    @Override
    public String getLast() {
        int n = this.names.size();
        int n2 = n - 1;
        return this.names.get(n2);
    }

    @Override
    public String getPath() {
        return this.location;
    }

    @Override
    public String getElement(String string) {
        if (!this.isEmpty(this.location)) {
            String string2 = this.elements.fetch(string);
            if (string2 == null && (string2 = this.getElementPath(this.location, string)) != null) {
                this.elements.cache(string, string2);
            }
            return string2;
        }
        return this.style.getElement(string);
    }

    protected String getElementPath(String string, String string2) {
        String string3 = this.style.getElement(string2);
        if (this.isEmpty(string3)) {
            return string;
        }
        if (this.isEmpty(string)) {
            return string3;
        }
        return string + "/" + string3 + "[1]";
    }

    @Override
    public String getAttribute(String string) {
        if (!this.isEmpty(this.location)) {
            String string2 = this.attributes.fetch(string);
            if (string2 == null && (string2 = this.getAttributePath(this.location, string)) != null) {
                this.attributes.cache(string, string2);
            }
            return string2;
        }
        return this.style.getAttribute(string);
    }

    protected String getAttributePath(String string, String string2) {
        String string3 = this.style.getAttribute(string2);
        if (this.isEmpty(string)) {
            return string3;
        }
        return string + "/@" + string3;
    }

    @Override
    public Iterator<String> iterator() {
        return this.names.iterator();
    }

    @Override
    public Expression getPath(int n) {
        return this.getPath(n, 0);
    }

    @Override
    public Expression getPath(int n, int n2) {
        int n3 = this.names.size() - 1;
        if (n3 - n2 >= n) {
            return new PathSection(n, n3 - n2);
        }
        return new PathSection(n, n);
    }

    private void parse(String string) throws Exception {
        if (string != null) {
            this.count = string.length();
            this.data = new char[this.count];
            string.getChars(0, this.count, this.data, 0);
        }
        this.path();
    }

    private void path() throws Exception {
        if (this.data[this.off] == '/') {
            throw new PathException("Path '%s' in %s references document root", this.path, this.type);
        }
        if (this.data[this.off] == '.') {
            this.skip();
        }
        while (this.off < this.count) {
            if (this.attribute) {
                throw new PathException("Path '%s' in %s references an invalid attribute", this.path, this.type);
            }
            this.segment();
        }
        this.truncate();
        this.build();
    }

    private void build() {
        int n = this.names.size();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            String string = this.prefixes.get(i);
            String string2 = this.names.get(i);
            int n3 = this.indexes.get(i);
            if (i > 0) {
                this.builder.append('/');
            }
            if (this.attribute && i == n2) {
                this.builder.append('@');
                this.builder.append(string2);
                continue;
            }
            if (string != null) {
                this.builder.append(string);
                this.builder.append(':');
            }
            this.builder.append(string2);
            this.builder.append('[');
            this.builder.append(n3);
            this.builder.append(']');
        }
        this.location = this.builder.toString();
    }

    private void skip() throws Exception {
        if (this.data.length > 1) {
            if (this.data[this.off + 1] != '/') {
                throw new PathException("Path '%s' in %s has an illegal syntax", this.path, this.type);
            }
            ++this.off;
        }
        this.start = ++this.off;
    }

    private void segment() throws Exception {
        char c = this.data[this.off];
        if (c == '/') {
            throw new PathException("Invalid path expression '%s' in %s", this.path, this.type);
        }
        if (c == '@') {
            this.attribute();
        } else {
            this.element();
        }
        this.align();
    }

    private void element() throws Exception {
        int n = this.off;
        int n2 = 0;
        while (this.off < this.count) {
            char c;
            if (!this.isValid(c = this.data[this.off++])) {
                if (c == '@') {
                    --this.off;
                    break;
                }
                if (c == '[') {
                    this.index();
                    break;
                }
                if (c == '/') break;
                throw new PathException("Illegal character '%s' in element for '%s' in %s", Character.valueOf(c), this.path, this.type);
            }
            ++n2;
        }
        this.element(n, n2);
    }

    private void attribute() throws Exception {
        int n = ++this.off;
        while (this.off < this.count) {
            char c;
            if (this.isValid(c = this.data[this.off++])) continue;
            throw new PathException("Illegal character '%s' in attribute for '%s' in %s", Character.valueOf(c), this.path, this.type);
        }
        if (this.off <= n) {
            throw new PathException("Attribute reference in '%s' for %s is empty", this.path, this.type);
        }
        this.attribute = true;
        this.attribute(n, this.off - n);
    }

    private void index() throws Exception {
        int n = 0;
        if (this.data[this.off - 1] == '[') {
            char c;
            while (this.off < this.count && this.isDigit(c = this.data[this.off++])) {
                n *= 10;
                n += c;
                n -= 48;
            }
        }
        if (this.data[this.off++ - 1] != ']') {
            throw new PathException("Invalid index for path '%s' in %s", this.path, this.type);
        }
        this.indexes.add(n);
    }

    private void truncate() throws Exception {
        if (this.off - 1 >= this.data.length) {
            --this.off;
        } else if (this.data[this.off - 1] == '/') {
            --this.off;
        }
    }

    private void align() throws Exception {
        int n;
        int n2 = this.names.size();
        if (n2 > (n = this.indexes.size())) {
            this.indexes.add(1);
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean isValid(char c) {
        return this.isLetter(c) || this.isSpecial(c);
    }

    private boolean isSpecial(char c) {
        return c == '_' || c == '-' || c == ':';
    }

    private boolean isLetter(char c) {
        return Character.isLetterOrDigit(c);
    }

    private void element(int n, int n2) {
        String string = new String(this.data, n, n2);
        if (n2 > 0) {
            this.element(string);
        }
    }

    private void attribute(int n, int n2) {
        String string = new String(this.data, n, n2);
        if (n2 > 0) {
            this.attribute(string);
        }
    }

    private void element(String string) {
        int n = string.indexOf(58);
        String string2 = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        String string3 = this.style.getElement(string);
        this.prefixes.add(string2);
        this.names.add(string3);
    }

    private void attribute(String string) {
        String string2 = this.style.getAttribute(string);
        this.prefixes.add(null);
        this.names.add(string2);
    }

    @Override
    public String toString() {
        int n = this.off - this.start;
        if (this.cache == null) {
            this.cache = new String(this.data, this.start, n);
        }
        return this.cache;
    }

    private class PathSection
    implements Expression {
        private List<String> cache = new ArrayList<String>();
        private String section;
        private String path;
        private int begin;
        private int end;

        public PathSection(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public boolean isPath() {
            return this.end - this.begin >= 1;
        }

        @Override
        public boolean isAttribute() {
            if (PathParser.this.attribute) {
                return this.end >= PathParser.this.names.size() - 1;
            }
            return false;
        }

        @Override
        public String getPath() {
            if (this.section == null) {
                this.section = this.getCanonicalPath();
            }
            return this.section;
        }

        @Override
        public String getElement(String string) {
            String string2 = this.getPath();
            if (string2 != null) {
                return PathParser.this.getElementPath(string2, string);
            }
            return string;
        }

        @Override
        public String getAttribute(String string) {
            String string2 = this.getPath();
            if (string2 != null) {
                return PathParser.this.getAttributePath(string2, string);
            }
            return string;
        }

        @Override
        public int getIndex() {
            return PathParser.this.indexes.get(this.begin);
        }

        @Override
        public String getPrefix() {
            return PathParser.this.prefixes.get(this.begin);
        }

        @Override
        public String getFirst() {
            return PathParser.this.names.get(this.begin);
        }

        @Override
        public String getLast() {
            return PathParser.this.names.get(this.end);
        }

        @Override
        public Expression getPath(int n) {
            return this.getPath(n, 0);
        }

        @Override
        public Expression getPath(int n, int n2) {
            return new PathSection(this.begin + n, this.end - n2);
        }

        @Override
        public Iterator<String> iterator() {
            if (this.cache.isEmpty()) {
                for (int i = this.begin; i <= this.end; ++i) {
                    String string = PathParser.this.names.get(i);
                    if (string == null) continue;
                    this.cache.add(string);
                }
            }
            return this.cache.iterator();
        }

        private String getCanonicalPath() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (n3 = 0; n3 < this.begin; ++n3) {
                n = PathParser.this.location.indexOf(47, n + 1);
            }
            n2 = n;
            while (n3 <= this.end) {
                if ((n2 = PathParser.this.location.indexOf(47, n2 + 1)) == -1) {
                    n2 = PathParser.this.location.length();
                }
                ++n3;
            }
            return PathParser.this.location.substring(n + 1, n2);
        }

        private String getFragment() {
            int n = PathParser.this.start;
            int n2 = 0;
            int n3 = 0;
            while (n3 <= this.end) {
                if (n >= PathParser.this.count) {
                    ++n;
                    break;
                }
                if (PathParser.this.data[n++] != '/' || ++n3 != this.begin) continue;
                n2 = n;
            }
            return new String(PathParser.this.data, n2, --n - n2);
        }

        @Override
        public String toString() {
            if (this.path == null) {
                this.path = this.getFragment();
            }
            return this.path;
        }
    }
}

