/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Reflector;

abstract class ParameterContact<T extends Annotation>
implements Contact {
    protected final Annotation[] labels;
    protected final Constructor factory;
    protected final Class owner;
    protected final int index;
    protected final T label;

    public ParameterContact(T t, Constructor constructor, int n) {
        this.labels = constructor.getParameterAnnotations()[n];
        this.owner = constructor.getDeclaringClass();
        this.factory = constructor;
        this.index = n;
        this.label = t;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public Class getType() {
        return this.factory.getParameterTypes()[this.index];
    }

    @Override
    public Class getDependent() {
        return Reflector.getParameterDependent(this.factory, this.index);
    }

    @Override
    public Class[] getDependents() {
        return Reflector.getParameterDependents(this.factory, this.index);
    }

    @Override
    public Class getDeclaringClass() {
        return this.owner;
    }

    @Override
    public Object get(Object object) {
        return null;
    }

    @Override
    public void set(Object object, Object object2) {
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        for (Annotation annotation : this.labels) {
            Class<? extends Annotation> clazz2 = annotation.annotationType();
            if (!clazz2.equals(clazz)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String toString() {
        return String.format("parameter %s of constructor %s", this.index, this.factory);
    }

    @Override
    public abstract String getName();
}

