/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Model;
import org.simpleframework.xml.core.ModelList;
import org.simpleframework.xml.core.ModelMap;
import org.simpleframework.xml.core.Section;

class ModelSection
implements Section {
    private LabelMap attributes;
    private LabelMap elements;
    private ModelMap models;
    private Model model;

    public ModelSection(Model model) {
        this.model = model;
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public String getPrefix() {
        return this.model.getPrefix();
    }

    @Override
    public String getPath(String string) throws Exception {
        Expression expression = this.model.getExpression();
        if (expression == null) {
            return string;
        }
        return expression.getElement(string);
    }

    @Override
    public String getAttribute(String string) throws Exception {
        Expression expression = this.model.getExpression();
        if (expression == null) {
            return string;
        }
        return expression.getAttribute(string);
    }

    @Override
    public Iterator<String> iterator() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.model) {
            arrayList.add(string);
        }
        return arrayList.iterator();
    }

    @Override
    public boolean isSection(String string) throws Exception {
        return this.getModels().get(string) != null;
    }

    public ModelMap getModels() throws Exception {
        if (this.models == null) {
            this.models = this.model.getModels();
        }
        return this.models;
    }

    @Override
    public Label getText() throws Exception {
        return this.model.getText();
    }

    @Override
    public LabelMap getAttributes() throws Exception {
        if (this.attributes == null) {
            this.attributes = this.model.getAttributes();
        }
        return this.attributes;
    }

    @Override
    public LabelMap getElements() throws Exception {
        if (this.elements == null) {
            this.elements = this.model.getElements();
        }
        return this.elements;
    }

    @Override
    public Label getElement(String string) throws Exception {
        return this.getElements().getLabel(string);
    }

    @Override
    public Section getSection(String string) throws Exception {
        Model model;
        ModelMap modelMap = this.getModels();
        ModelList modelList = (ModelList)modelMap.get(string);
        if (modelList != null && (model = modelList.take()) != null) {
            return new ModelSection(model);
        }
        return null;
    }
}

