/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.MethodException;
import org.simpleframework.xml.core.MethodPart;

class MethodContact
implements Contact {
    private Annotation label;
    private MethodPart set;
    private MethodPart get;
    private Class[] items;
    private Class owner;
    private Class item;
    private Class type;
    private String name;

    public MethodContact(MethodPart methodPart) {
        this(methodPart, null);
    }

    public MethodContact(MethodPart methodPart, MethodPart methodPart2) {
        this.owner = methodPart.getDeclaringClass();
        this.label = methodPart.getAnnotation();
        this.items = methodPart.getDependents();
        this.item = methodPart.getDependent();
        this.type = methodPart.getType();
        this.name = methodPart.getName();
        this.set = methodPart2;
        this.get = methodPart;
    }

    @Override
    public boolean isReadOnly() {
        return this.set == null;
    }

    public MethodPart getRead() {
        return this.get;
    }

    public MethodPart getWrite() {
        return this.set;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        T t = this.get.getAnnotation(clazz);
        if (clazz == this.label.annotationType()) {
            return (T)this.label;
        }
        if (t == null && this.set != null) {
            return this.set.getAnnotation(clazz);
        }
        return t;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Class getDependent() {
        return this.item;
    }

    @Override
    public Class[] getDependents() {
        return this.items;
    }

    @Override
    public Class getDeclaringClass() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void set(Object object, Object object2) throws Exception {
        Method method = this.get.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        if (this.set == null) {
            throw new MethodException("Property '%s' is read only in %s", this.name, clazz);
        }
        this.set.getMethod().invoke(object, object2);
    }

    @Override
    public Object get(Object object) throws Exception {
        return this.get.getMethod().invoke(object, new Object[0]);
    }

    @Override
    public String toString() {
        return String.format("method '%s'", this.name);
    }
}

