/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Arrays;
import org.simpleframework.xml.core.Label;

class KeyBuilder {
    private final Label label;

    public KeyBuilder(Label label) {
        this.label = label;
    }

    public Object getKey() throws Exception {
        if (this.label.isAttribute()) {
            return this.getKey(KeyType.ATTRIBUTE);
        }
        return this.getKey(KeyType.ELEMENT);
    }

    private Object getKey(KeyType keyType) throws Exception {
        String[] stringArray = this.label.getPaths();
        String string = this.getKey(stringArray);
        if (keyType == null) {
            return string;
        }
        return new Key(keyType, string);
    }

    private String getKey(String[] stringArray) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            Arrays.sort(stringArray);
            for (String string : stringArray) {
                stringBuilder.append(string);
                stringBuilder.append('>');
            }
        }
        return stringBuilder.toString();
    }

    private static class Key {
        private final KeyType type;
        private final String value;

        public Key(KeyType keyType, String string) throws Exception {
            this.value = string;
            this.type = keyType;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.equals(key);
            }
            return false;
        }

        public boolean equals(Key key) {
            if (this.type == key.type) {
                return key.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }

    private static enum KeyType {
        TEXT,
        ATTRIBUTE,
        ELEMENT;

    }
}

