/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class InstanceFactory {
    private final Cache<Constructor> cache = new ConcurrentCache<Constructor>();

    public Instance getInstance(Value value) {
        return new ValueInstance(value);
    }

    public Instance getInstance(Class clazz) {
        return new ClassInstance(clazz);
    }

    protected Object getObject(Class clazz) throws Exception {
        Constructor constructor = this.cache.fetch(clazz);
        if (constructor == null) {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            this.cache.cache(clazz, constructor);
        }
        return constructor.newInstance(new Object[0]);
    }

    private class ClassInstance
    implements Instance {
        private Object value;
        private Class type;

        public ClassInstance(Class clazz) {
            this.type = clazz;
        }

        @Override
        public Object getInstance() throws Exception {
            if (this.value == null) {
                this.value = InstanceFactory.this.getObject(this.type);
            }
            return this.value;
        }

        @Override
        public Object setInstance(Object object) throws Exception {
            this.value = object;
            return this.value;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        @Override
        public boolean isReference() {
            return false;
        }
    }

    private class ValueInstance
    implements Instance {
        private final Value value;
        private final Class type;

        public ValueInstance(Value value) {
            this.type = value.getType();
            this.value = value;
        }

        @Override
        public Object getInstance() throws Exception {
            if (this.value.isReference()) {
                return this.value.getValue();
            }
            Object object = InstanceFactory.this.getObject(this.type);
            if (this.value != null) {
                this.value.setValue(object);
            }
            return object;
        }

        @Override
        public Object setInstance(Object object) {
            if (this.value != null) {
                this.value.setValue(object);
            }
            return object;
        }

        @Override
        public boolean isReference() {
            return this.value.isReference();
        }

        @Override
        public Class getType() {
            return this.type;
        }
    }
}

