/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.ElementMapUnion;
import org.simpleframework.xml.ElementUnion;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.ElementLabel;
import org.simpleframework.xml.core.ElementListLabel;
import org.simpleframework.xml.core.ElementMapLabel;
import org.simpleframework.xml.core.Extractor;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.stream.Format;

class ExtractorFactory {
    private final Annotation label;
    private final Contact contact;
    private final Format format;

    public ExtractorFactory(Contact contact, Annotation annotation, Format format) {
        this.contact = contact;
        this.format = format;
        this.label = annotation;
    }

    public Extractor getInstance() throws Exception {
        return (Extractor)this.getInstance(this.label);
    }

    private Object getInstance(Annotation annotation) throws Exception {
        ExtractorBuilder extractorBuilder = this.getBuilder(annotation);
        Constructor constructor = extractorBuilder.getConstructor();
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(this.contact, annotation, this.format);
    }

    private ExtractorBuilder getBuilder(Annotation annotation) throws Exception {
        if (annotation instanceof ElementUnion) {
            return new ExtractorBuilder(ElementUnion.class, ElementExtractor.class);
        }
        if (annotation instanceof ElementListUnion) {
            return new ExtractorBuilder(ElementListUnion.class, ElementListExtractor.class);
        }
        if (annotation instanceof ElementMapUnion) {
            return new ExtractorBuilder(ElementMapUnion.class, ElementMapExtractor.class);
        }
        throw new PersistenceException("Annotation %s is not a union", annotation);
    }

    private static class ElementMapExtractor
    implements Extractor<ElementMap> {
        private final Contact contact;
        private final ElementMapUnion union;
        private final Format format;

        public ElementMapExtractor(Contact contact, ElementMapUnion elementMapUnion, Format format) throws Exception {
            this.contact = contact;
            this.format = format;
            this.union = elementMapUnion;
        }

        public ElementMap[] getAnnotations() {
            return this.union.value();
        }

        @Override
        public Label getLabel(ElementMap elementMap) {
            return new ElementMapLabel(this.contact, elementMap, this.format);
        }

        @Override
        public Class getType(ElementMap elementMap) {
            return elementMap.valueType();
        }
    }

    private static class ElementListExtractor
    implements Extractor<ElementList> {
        private final Contact contact;
        private final ElementListUnion union;
        private final Format format;

        public ElementListExtractor(Contact contact, ElementListUnion elementListUnion, Format format) throws Exception {
            this.contact = contact;
            this.format = format;
            this.union = elementListUnion;
        }

        public ElementList[] getAnnotations() {
            return this.union.value();
        }

        @Override
        public Label getLabel(ElementList elementList) {
            return new ElementListLabel(this.contact, elementList, this.format);
        }

        @Override
        public Class getType(ElementList elementList) {
            return elementList.type();
        }
    }

    private static class ElementExtractor
    implements Extractor<Element> {
        private final Contact contact;
        private final ElementUnion union;
        private final Format format;

        public ElementExtractor(Contact contact, ElementUnion elementUnion, Format format) throws Exception {
            this.contact = contact;
            this.format = format;
            this.union = elementUnion;
        }

        public Element[] getAnnotations() {
            return this.union.value();
        }

        @Override
        public Label getLabel(Element element) {
            return new ElementLabel(this.contact, element, this.format);
        }

        @Override
        public Class getType(Element element) {
            Class clazz = element.type();
            if (clazz == Void.TYPE) {
                return this.contact.getType();
            }
            return clazz;
        }
    }

    private static class ExtractorBuilder {
        private final Class label;
        private final Class type;

        public ExtractorBuilder(Class clazz, Class clazz2) {
            this.label = clazz;
            this.type = clazz2;
        }

        private Constructor getConstructor() throws Exception {
            return this.type.getConstructor(Contact.class, this.label, Format.class);
        }
    }
}

