/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collections;
import java.util.Map;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Group;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Repeater;
import org.simpleframework.xml.core.UnionException;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class CompositeMapUnion
implements Repeater {
    private final LabelMap elements;
    private final Expression path;
    private final Context context;
    private final Group group;
    private final Style style;
    private final Type type;

    public CompositeMapUnion(Context context, Group group, Expression expression, Type type) throws Exception {
        this.elements = group.getElements();
        this.style = context.getStyle();
        this.context = context;
        this.group = group;
        this.type = type;
        this.path = expression;
    }

    @Override
    public Object read(InputNode inputNode) throws Exception {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode);
    }

    @Override
    public Object read(InputNode inputNode, Object object) throws Exception {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.read(inputNode, object);
    }

    @Override
    public boolean validate(InputNode inputNode) throws Exception {
        String string = inputNode.getName();
        String string2 = this.path.getElement(string);
        Label label = (Label)this.elements.get(string2);
        Converter converter = label.getConverter(this.context);
        return converter.validate(inputNode);
    }

    @Override
    public void write(OutputNode outputNode, Object object) throws Exception {
        Map map = (Map)object;
        if (this.group.isInline()) {
            if (!map.isEmpty()) {
                this.write(outputNode, map);
            } else if (!outputNode.isCommitted()) {
                outputNode.remove();
            }
        } else {
            this.write(outputNode, map);
        }
    }

    private void write(OutputNode outputNode, Map map) throws Exception {
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (v == null) continue;
            Class<?> clazz = v.getClass();
            Label label = this.group.getLabel(clazz);
            if (label == null) {
                throw new UnionException("Value of %s not declared in %s with annotation %s", clazz, this.type, this.group);
            }
            this.write(outputNode, k, v, label);
        }
    }

    private void write(OutputNode outputNode, Object object, Object object2, Label label) throws Exception {
        Converter converter = label.getConverter(this.context);
        Map<Object, Object> map = Collections.singletonMap(object, object2);
        if (!label.isInline()) {
            String string = label.getName();
            String string2 = this.style.getElement(string);
            if (!outputNode.isCommitted()) {
                outputNode.setName(string2);
            }
        }
        converter.write(outputNode, map);
    }
}

