/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Array;
import org.simpleframework.xml.core.ArrayInstance;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.Position;

class ArrayFactory
extends Factory {
    public ArrayFactory(Context context, Type type) {
        super(context, type);
    }

    @Override
    public Object getInstance() throws Exception {
        Class clazz = this.getComponentType();
        if (clazz != null) {
            return Array.newInstance(clazz, 0);
        }
        return null;
    }

    public Instance getInstance(InputNode inputNode) throws Exception {
        Position position = inputNode.getPosition();
        Value value = this.getOverride(inputNode);
        if (value == null) {
            throw new ElementException("Array length required for %s at %s", this.type, position);
        }
        Class clazz = value.getType();
        return this.getInstance(value, clazz);
    }

    private Instance getInstance(Value value, Class clazz) throws Exception {
        Class clazz2 = this.getComponentType();
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new InstantiationException("Array of type %s cannot hold %s for %s", clazz2, clazz, this.type);
        }
        return new ArrayInstance(value);
    }

    private Class getComponentType() throws Exception {
        Class clazz = this.getType();
        if (!clazz.isArray()) {
            throw new InstantiationException("The %s not an array for %s", clazz, this.type);
        }
        return clazz.getComponentType();
    }
}

