/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.convert;

import java.util.Map;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Reference;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;

public class RegistryStrategy
implements Strategy {
    private final Registry registry;
    private final Strategy strategy;

    public RegistryStrategy(Registry registry) {
        this(registry, new TreeStrategy());
    }

    public RegistryStrategy(Registry registry, Strategy strategy) {
        this.registry = registry;
        this.strategy = strategy;
    }

    @Override
    public Value read(Type type, NodeMap<InputNode> nodeMap, Map map) throws Exception {
        Value value = this.strategy.read(type, nodeMap, map);
        if (this.isReference(value)) {
            return value;
        }
        return this.read(type, nodeMap, value);
    }

    private Value read(Type type, NodeMap<InputNode> nodeMap, Value value) throws Exception {
        Converter converter = this.lookup(type, value);
        InputNode inputNode = nodeMap.getNode();
        if (converter != null) {
            Object t = converter.read(inputNode);
            Class clazz = type.getType();
            if (value != null) {
                value.setValue(t);
            }
            return new Reference(value, t, clazz);
        }
        return value;
    }

    @Override
    public boolean write(Type type, Object object, NodeMap<OutputNode> nodeMap, Map map) throws Exception {
        boolean bl = this.strategy.write(type, object, nodeMap, map);
        if (!bl) {
            return this.write(type, object, nodeMap);
        }
        return bl;
    }

    private boolean write(Type type, Object object, NodeMap<OutputNode> nodeMap) throws Exception {
        Converter converter = this.lookup(type, object);
        OutputNode outputNode = nodeMap.getNode();
        if (converter != null) {
            converter.write(outputNode, object);
            return true;
        }
        return false;
    }

    private Converter lookup(Type type, Value value) throws Exception {
        Class clazz = type.getType();
        if (value != null) {
            clazz = value.getType();
        }
        return this.registry.lookup(clazz);
    }

    private Converter lookup(Type type, Object object) throws Exception {
        Class<?> clazz = type.getType();
        if (object != null) {
            clazz = object.getClass();
        }
        return this.registry.lookup(clazz);
    }

    private boolean isReference(Value value) {
        return value != null && value.isReference();
    }
}

