/*
 * Decompiled with CFR 0.152.
 */
package com.ecs.dbsekycapi;

import a.a;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import com.ecs.cdslutils.Base64;
import com.ecs.cdslutils.DialogUtils;
import com.ecs.cdslutils.ErrorHandler;
import com.ecs.cdslutils.Globals;
import com.ecs.cdslutils.ProgressUtil;
import com.ecs.cdslutils.ResponseHandler;
import com.ecs.cdslutils.ServerUtil;
import com.ecs.cdslutils.Verhoeff;
import com.ecs.cdslxsds.ECSRDKycRequest;
import com.ecs.cdslxsds.ECSRDKycResponse;
import com.ecs.cdslxsds.ECSRDOtpRequest;
import com.ecs.cdslxsds.ECSRDOtpResponse;
import com.ecs.cdslxsds.ESignLibApiParams;
import com.ecs.cdslxsds.XMLUtilities;
import com.ecs.dbsekycapi.DBSFingerprintCaptureActivity;
import com.ecs.dbsekycapi.R;
import com.google.android.material.textfield.TextInputEditText;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class BiometricActivity
extends AppCompatActivity {
    private String consent;
    private ActivityResultLauncher<Intent> bioLauncher;
    private TextView tvAspId;
    private TextView tvTxnId;
    private TextView tvTimestamp;
    private TextView txtError;
    private TextView tvTimeRemaining;
    private TextView resendOtp;
    private TextView tvBtnText;
    private TextView txtEsignType;
    private TextView maskedDetails;
    private Spinner spConsent;
    private CountDownTimer resendOtpTimer = null;
    private boolean toBeValidateOtp = false;
    private String aspTxn;
    private String aaNoForValidate = null;
    private ServerUtil util = ServerUtil.getInstance();
    private ECSRDOtpResponse otpResponse;
    private ESignLibApiParams apiParams;
    private LinearLayout aadhaarLayout;
    private LinearLayout otpLayout;
    private TextInputEditText edtAadhaarNo;
    private TextInputEditText edtOtp;
    private CheckBox cbConsent;
    private CardView btnProceed;
    private String authMode;
    private ResponseHandler responseHandler;
    private ErrorHandler errorHandler;

    private void setUpEsignType() {
        if (this.authMode.equals("1")) {
            this.txtEsignType.setText((CharSequence)this.getString(R.string.esign_type, new Object[]{"OTP"}));
        } else {
            this.txtEsignType.setText((CharSequence)this.getString(R.string.esign_type, new Object[]{"Biometric"}));
        }
    }

    private void setUpConsent() {
        ArrayAdapter arrayAdapter;
        BiometricActivity biometricActivity = this;
        biometricActivity.consent = biometricActivity.getString(R.string.consent);
        Object[] objectArray = new String[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "English";
        ArrayAdapter arrayAdapter2 = arrayAdapter;
        arrayAdapter = new ArrayAdapter((Context)this, 0x1090009, objectArray2);
        biometricActivity.spConsent.setAdapter((SpinnerAdapter)arrayAdapter2);
        biometricActivity.spConsent.setSelection(0);
        ((TextView)biometricActivity.findViewById(R.id.txtConsent)).setText((CharSequence)this.consent);
    }

    private void textWatcher() {
        this.edtAadhaarNo.addTextChangedListener(new TextWatcher(){

            public final void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public final void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            /*
             * Enabled aggressive block sorting
             */
            public final void afterTextChanged(Editable object) {
                if (((String)(object = object.toString().trim())).length() <= 1) {
                    BiometricActivity.this.txtError.setText((CharSequence)"");
                    return;
                }
                if (((String)object).length() != 12 && ((String)object).length() != 16) {
                    BiometricActivity biometricActivity = BiometricActivity.this;
                    biometricActivity.updateUi(biometricActivity.getString(R.string.enter_12_or_16_vid_num), false);
                    return;
                }
                if (!Verhoeff.validateVerhoeff((String)object) && ((String)object).length() == 12 || !Verhoeff.validateVerhoeff((String)object) && ((String)object).length() == 16) {
                    BiometricActivity biometricActivity = BiometricActivity.this;
                    biometricActivity.updateUi(biometricActivity.getString(R.string.aadhaar_validation_failed), false);
                    return;
                }
                BiometricActivity.this.updateUi("", true);
            }
        });
    }

    private void receivedBundle() {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            if (bundle.containsKey("API_PARAMS")) {
                this.apiParams = (ESignLibApiParams)bundle.getSerializable("API_PARAMS");
            }
            if (bundle.containsKey("ASP_TXN")) {
                this.aspTxn = bundle.getString("ASP_TXN");
            }
            if (bundle.containsKey("AUTH_MODE")) {
                this.authMode = bundle.getString("AUTH_MODE");
            }
        } else {
            BiometricActivity biometricActivity = this;
            this.errorHandler.returnError((Activity)biometricActivity, biometricActivity.aspTxn, "E014", "Null Data");
        }
    }

    private void updateUi(String string2, boolean bl) {
        if (bl) {
            BiometricActivity biometricActivity = this;
            biometricActivity.btnProceed.setCardBackgroundColor(this.getResources().getColor(R.color.colorButtonEnabled));
            biometricActivity.btnProceed.setClickable(true);
            biometricActivity.btnProceed.setEnabled(true);
        } else {
            BiometricActivity biometricActivity = this;
            biometricActivity.btnProceed.setCardBackgroundColor(this.getResources().getColor(R.color.colorBlue));
            biometricActivity.btnProceed.setClickable(false);
            biometricActivity.btnProceed.setEnabled(false);
        }
        BiometricActivity biometricActivity = this;
        biometricActivity.txtError.setText((CharSequence)string2);
        ((TextView)biometricActivity.findViewById(R.id.tvBtnText)).setTextColor(-1);
    }

    private void onClickListener() {
        BiometricActivity biometricActivity = this;
        biometricActivity.btnProceed.setOnClickListener(object -> {
            if (this.toBeValidateOtp) {
                object = String.valueOf(this.edtOtp.getText());
                if (((String)object).equals("")) {
                    DialogUtils.showErrorDialog((Context)this, "Please enter otp");
                } else if (((String)object).length() != 6) {
                    DialogUtils.showErrorDialog((Context)this, "Please enter valid otp");
                } else {
                    this.validateOtp((String)object);
                }
            } else {
                this.doProceed();
            }
        });
        biometricActivity.resendOtp.setOnClickListener(view -> {
            BiometricActivity biometricActivity = this;
            biometricActivity.generateOtp(biometricActivity.aaNoForValidate);
        });
        biometricActivity.findViewById(R.id.cancel).setOnClickListener(object -> {
            object = object2.resendOtpTimer;
            if (object != null) {
                object.cancel();
            }
            BiometricActivity biometricActivity = object2;
            Object object2 = biometricActivity.aspTxn;
            object = biometricActivity.getString(R.string.user_Cancel);
            object2.errorHandler.returnError((Activity)biometricActivity, (String)object2, "E998", (String)object);
        });
    }

    private void viewInitialize() {
        BiometricActivity biometricActivity = this;
        biometricActivity.spConsent = (Spinner)biometricActivity.findViewById(R.id.sp_consent);
        biometricActivity.txtError = (TextView)biometricActivity.findViewById(R.id.error);
        biometricActivity.tvAspId = (TextView)biometricActivity.findViewById(R.id.aspId);
        biometricActivity.tvTimestamp = (TextView)biometricActivity.findViewById(R.id.dateTime);
        biometricActivity.tvTxnId = (TextView)biometricActivity.findViewById(R.id.transcId);
        biometricActivity.edtAadhaarNo = (TextInputEditText)biometricActivity.findViewById(R.id.etEkycAadhaarNo);
        biometricActivity.edtOtp = (TextInputEditText)biometricActivity.findViewById(R.id.edtOtp);
        biometricActivity.btnProceed = (CardView)biometricActivity.findViewById(R.id.btnProceed);
        biometricActivity.cbConsent = (CheckBox)biometricActivity.findViewById(R.id.ch_consent);
        biometricActivity.txtEsignType = (TextView)biometricActivity.findViewById(R.id.esignType);
        biometricActivity.aadhaarLayout = (LinearLayout)biometricActivity.findViewById(R.id.aadhaarLayout);
        biometricActivity.tvTimeRemaining = (TextView)biometricActivity.findViewById(R.id.tvTimeRemaining);
        biometricActivity.resendOtp = (TextView)biometricActivity.findViewById(R.id.resendOtp);
        biometricActivity.tvBtnText = (TextView)biometricActivity.findViewById(R.id.tvBtnText);
        biometricActivity.maskedDetails = (TextView)biometricActivity.findViewById(R.id.maskedDetails);
        biometricActivity.otpLayout = (LinearLayout)biometricActivity.findViewById(R.id.otpLayout);
    }

    private void extractXml() {
        BiometricActivity biometricActivity = object;
        String string2 = biometricActivity.apiParams.getRequestXML();
        Object object = object.convertTimestamp(XMLUtilities.getXMLValue(string2, "ts"));
        String string3 = XMLUtilities.getXMLValue(string2, "aspId");
        String string4 = XMLUtilities.getXMLValue(string2, "txn");
        biometricActivity.tvAspId.setText((CharSequence)string3);
        biometricActivity.tvTxnId.setText((CharSequence)string4);
        biometricActivity.tvTimestamp.setText((CharSequence)object);
    }

    private void doProceed() {
        String string2 = String.valueOf(this.edtAadhaarNo.getText());
        if (string2.length() != 12 && string2.length() != 16) {
            BiometricActivity biometricActivity = this;
            DialogUtils.showErrorDialog((Context)biometricActivity, biometricActivity.getString(R.string.invalid_aadhaar_no));
            return;
        }
        if (!Verhoeff.validateVerhoeff(string2)) {
            BiometricActivity biometricActivity = this;
            DialogUtils.showErrorDialog((Context)biometricActivity, biometricActivity.getString(R.string.invalid_aadhaar_no));
            return;
        }
        if (!this.cbConsent.isChecked()) {
            BiometricActivity biometricActivity = this;
            DialogUtils.showErrorDialog((Context)biometricActivity, biometricActivity.getString(R.string.select_consent));
            return;
        }
        if (this.authMode.equals("1")) {
            this.cbConsent.setEnabled(false);
            this.generateOtp(string2);
        } else {
            this.navToCaptureBio(string2);
        }
    }

    private void navToCaptureBio(String string2) {
        Intent intent;
        Intent intent2;
        Intent intent3 = intent2 = intent;
        Intent intent4 = intent2;
        intent4((Context)this, DBSFingerprintCaptureActivity.class);
        intent4.putExtra("AADHAAR_NUMBER", string2);
        intent2.putExtra("API_PARAMS", (Serializable)this.apiParams);
        intent2.putExtra("CONSENT", this.consent);
        intent3.putExtra("ASP_TXN", this.aspTxn);
        intent3.putExtra("CONSENT_LANGUAGE", "ENGLISH");
        intent.putExtra("AUTH_MODE", this.authMode);
        this.bioLauncher.launch((Object)intent2);
    }

    private void registerBioLauncher() {
        ActivityResultContracts.StartActivityForResult startActivityForResult;
        BiometricActivity biometricActivity = biometricActivity2;
        BiometricActivity biometricActivity2 = startActivityForResult;
        startActivityForResult = new ActivityResultContracts.StartActivityForResult();
        biometricActivity.bioLauncher = biometricActivity.registerForActivityResult((ActivityResultContract)biometricActivity2, object -> {
            if ((object = object.getData()) != null) {
                if (object.getBooleanExtra("ERROR", false)) {
                    object = object.getStringExtra("ESIGN_ERROR_XML");
                    object2.responseHandler.returnErrorResponse((Activity)object2, (String)object);
                } else {
                    object = object.getStringExtra("ESIGN_RESPONSE_XML");
                    object2.responseHandler.returnSuccessResponse((Activity)object2, (String)object);
                }
            } else {
                BiometricActivity biometricActivity = object2;
                Object object2 = biometricActivity.aspTxn;
                object = biometricActivity.getString(R.string.null_data);
                object2.errorHandler.returnError((Activity)biometricActivity, (String)object2, "Error-", (String)object);
            }
        });
    }

    private void startResendOtpTimer() {
        this.resendOtpTimer = new CountDownTimer(){

            public final void onTick(long l) {
                BiometricActivity.this.tvTimeRemaining.setText((CharSequence)String.valueOf(l / 1000L));
            }

            public final void onFinish() {
                b b2 = this;
                b2.BiometricActivity.this.tvTimeRemaining.setVisibility(8);
                b2.BiometricActivity.this.resendOtp.setEnabled(true);
                b2.BiometricActivity.this.resendOtp.setTextColor(ContextCompat.getColor((Context)BiometricActivity.this, (int)R.color.colorButtonEnabled));
                BiometricActivity.access$402(b2.BiometricActivity.this, null);
            }
        }.start();
    }

    private void setMaskedDetails() {
        String string2 = this.otpResponse.getMaskedMobile();
        if (string2 != null) {
            this.maskedDetails.setText((CharSequence)this.getString(R.string.set_masked_Mob, new Object[]{string2}));
        }
    }

    private /* synthetic */ void lambda$validateOtp$8(ECSRDKycResponse object) {
        BiometricActivity biometricActivity = this;
        ProgressUtil.getInstance().destroyProgressDialog();
        object = biometricActivity.decodeBase64(((ECSRDKycResponse)object).getESIGN_XML());
        biometricActivity.responseHandler.returnSuccessResponse((Activity)this, (String)object);
    }

    private /* synthetic */ void lambda$validateOtp$7(ECSRDKycResponse eCSRDKycResponse) {
        ProgressUtil.getInstance().destroyProgressDialog();
        this.responseHandler.returnErrorResponse((Activity)this, eCSRDKycResponse.getErrXML());
    }

    private /* synthetic */ void lambda$generateOtp$5(String string2, ECSRDOtpResponse eCSRDOtpResponse) {
        BiometricActivity biometricActivity = this;
        ProgressUtil.getInstance().destroyProgressDialog();
        this.aaNoForValidate = string2;
        biometricActivity.otpResponse = eCSRDOtpResponse;
        biometricActivity.aadhaarLayout.setVisibility(8);
        biometricActivity.otpLayout.setVisibility(0);
        biometricActivity.tvBtnText.setVisibility(0);
        biometricActivity.tvBtnText.setText((CharSequence)this.getString(R.string.validate_otp));
        biometricActivity.toBeValidateOtp = true;
        biometricActivity.startResendOtpTimer();
        biometricActivity.setMaskedDetails();
        biometricActivity.edtOtp.requestFocus();
    }

    private /* synthetic */ void lambda$generateOtp$4(ECSRDOtpResponse object) {
        ProgressUtil.getInstance().destroyProgressDialog();
        BiometricActivity biometricActivity = object2;
        ECSRDOtpResponse eCSRDOtpResponse = object;
        Object object2 = object2.aspTxn;
        object = eCSRDOtpResponse.getStatusCode();
        String string2 = eCSRDOtpResponse.getStatusDescription();
        object2.errorHandler.returnError((Activity)biometricActivity, (String)object2, (String)object, string2);
    }

    public static /* synthetic */ CountDownTimer access$402(BiometricActivity biometricActivity, CountDownTimer countDownTimer) {
        biometricActivity.resendOtpTimer = countDownTimer;
        return countDownTimer;
    }

    public void onCreate(Bundle bundle) {
        BiometricActivity biometricActivity = this;
        super.onCreate(bundle);
        biometricActivity.setContentView(R.layout.activity_ekyc_dbs);
        biometricActivity.errorHandler = new ErrorHandler();
        biometricActivity.responseHandler = new ResponseHandler();
        biometricActivity.receivedBundle();
        biometricActivity.viewInitialize();
        biometricActivity.extractXml();
        biometricActivity.onClickListener();
        biometricActivity.textWatcher();
        biometricActivity.setUpConsent();
        biometricActivity.registerBioLauncher();
        biometricActivity.setUpEsignType();
        biometricActivity.aadhaarLayout.setVisibility(0);
        biometricActivity.otpLayout.setVisibility(8);
        biometricActivity.btnProceed.setCardBackgroundColor(this.getResources().getColor(R.color.colorBlue));
        biometricActivity.btnProceed.setClickable(false);
        biometricActivity.btnProceed.setEnabled(false);
        ((TextView)biometricActivity.findViewById(R.id.tvBtnText)).setTextColor(-1);
    }

    public void onBackPressed() {
        BiometricActivity biometricActivity = object;
        Object object = biometricActivity.aspTxn;
        String string2 = biometricActivity.getString(R.string.user_Cancel);
        object.errorHandler.returnError((Activity)biometricActivity, (String)object, "E998", string2);
    }

    public String convertTimestamp(String string2) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2;
        SimpleDateFormat simpleDateFormat3 = simpleDateFormat2;
        simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
        SimpleDateFormat simpleDateFormat4 = simpleDateFormat;
        simpleDateFormat4("dd MMM yyyy, HH:mm", Locale.getDefault());
        try {
            return simpleDateFormat.format(simpleDateFormat3.parse(string2));
        }
        catch (ParseException parseException) {
            return "Invalid Timestamp";
        }
    }

    public void generateOtp(String string2) {
        ProgressUtil.getInstance().showProgressDialog((Context)this, "Generating otp...");
        new Thread(() -> {
            ECSRDOtpRequest eCSRDOtpRequest;
            Object object = eCSRDOtpRequest;
            ECSRDOtpRequest eCSRDOtpRequest2 = object;
            ((ECSRDOtpRequest)object)();
            eCSRDOtpRequest2.setUid(string2);
            eCSRDOtpRequest2.setChannel("00");
            eCSRDOtpRequest.setConsent(this.consent);
            if (this.apiParams.getEnvironment().equalsIgnoreCase("prod")) {
                BiometricActivity biometricActivity = this;
                String string3 = Globals.getProdEsignUrl();
                String string4 = biometricActivity.aspTxn;
                object = this.util.performServerCall((Activity)biometricActivity, string3, object, string4, ECSRDOtpResponse.class, true);
            } else {
                BiometricActivity biometricActivity = this;
                String string5 = Globals.getUatEsignUrl();
                String string6 = biometricActivity.aspTxn;
                object = this.util.performServerCall((Activity)biometricActivity, string5, object, string6, ECSRDOtpResponse.class, true);
            }
            if (object != null) {
                if (((ECSRDOtpResponse)object).isError()) {
                    BiometricActivity biometricActivity = this;
                    biometricActivity.runOnUiThread(() -> biometricActivity.lambda$generateOtp$4((ECSRDOtpResponse)object));
                } else {
                    BiometricActivity biometricActivity = this;
                    biometricActivity.runOnUiThread(() -> biometricActivity.lambda$generateOtp$5(string2, (ECSRDOtpResponse)object));
                }
            }
        }).start();
    }

    public void validateOtp(String string2) {
        ProgressUtil.getInstance().showProgressDialog((Context)this, "Validating otp...");
        new Thread(() -> {
            ECSRDKycRequest eCSRDKycRequest;
            String string2;
            Object object2;
            BiometricActivity biometricActivity;
            Object object3;
            try {
                int n;
                Resources resources;
                if (this.apiParams.getEnvironment().equalsIgnoreCase("prod")) {
                    resources = this.getResources();
                    n = R.raw.uidai_auth_prod;
                } else {
                    resources = this.getResources();
                    n = R.raw.uidai_encryptionkey_pre_production;
                }
                object3 = resources.openRawResource(n);
                biometricActivity = this;
                object3 = a.b.a((String)object2, (InputStream)object3);
            }
            catch (Exception exception) {
                ProgressUtil.getInstance().destroyProgressDialog();
                String string3 = this.aspTxn;
                String string4 = exception.getMessage();
                this.errorHandler.returnError((Activity)this, string3, "", string4);
                return;
            }
            String string5 = string2;
            {
                string2 = new String(((a)object3).a().getBytes());
            }
            Object object5 = object3 = eCSRDKycRequest;
            object5 = object3;
            ((ECSRDKycRequest)object5)();
            ((ECSRDKycRequest)object5).setPfr(false);
            ((ECSRDKycRequest)object5).setLr(false);
            ((ECSRDKycRequest)object3).setConsent(this.consent);
            ((ECSRDKycRequest)object3).setPidData(Base64.encode(string5.replace("/ >", "/>").getBytes()));
            ((ECSRDKycRequest)object4).setUid(this.aaNoForValidate);
            ((ECSRDKycRequest)object4).setUsesBio(false);
            ((ECSRDKycRequest)object4).setUsesBt(null);
            ((ECSRDKycRequest)object4).setUsesOtp(true);
            ((ECSRDKycRequest)object3).setUdf1((String)object2);
            ((ECSRDKycRequest)object3).setOtpTxn(this.otpResponse.getTransactionId());
            eCSRDKycRequest.setEsignXML(Base64.encode(this.apiParams.getRequestXML().getBytes()));
            if (biometricActivity.apiParams.getEnvironment().equalsIgnoreCase("prod")) {
                BiometricActivity biometricActivity2 = this;
                object2 = Globals.getProdEsignUrl();
                string5 = biometricActivity2.aspTxn;
                object2 = this.util.performServerCall((Activity)biometricActivity2, (String)object2, object3, string5, ECSRDKycResponse.class, true);
            } else {
                BiometricActivity biometricActivity3 = this;
                object2 = Globals.getUatEsignUrl();
                string5 = biometricActivity3.aspTxn;
                object2 = this.util.performServerCall((Activity)biometricActivity3, (String)object2, object3, string5, ECSRDKycResponse.class, true);
            }
            if (object2 == null) return;
            if (((ECSRDKycResponse)object2).isError()) {
                BiometricActivity biometricActivity4 = this;
                biometricActivity4.runOnUiThread(() -> biometricActivity4.lambda$validateOtp$7((ECSRDKycResponse)object2));
                return;
            }
            BiometricActivity biometricActivity5 = this;
            biometricActivity5.runOnUiThread(() -> biometricActivity5.lambda$validateOtp$8((ECSRDKycResponse)object2));
        }).start();
    }

    public String decodeBase64(String string2) {
        Object object = new byte[0];
        int n = Build.VERSION.SDK_INT;
        if (n >= 8) {
            object = android.util.Base64.decode((String)string2, (int)0);
        }
        if (n >= 19) {
            return new String((byte[])object, StandardCharsets.UTF_8);
        }
        return new String((byte[])object);
    }
}

