/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.utils;

import be.quodlibet.boxable.utils.FontUtils;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;

public final class PDStreamUtils {
    private PDStreamUtils() {
    }

    public static void write(PDPageContentStream stream, String text, PDFont font, float fontSize, float x, float y, Color color) {
        try {
            stream.beginText();
            stream.setFont(font, fontSize);
            stream.newLineAtOffset(x, y - FontUtils.getDescent(font, fontSize) - FontUtils.getHeight(font, fontSize));
            stream.setNonStrokingColor(color);
            stream.showText(text);
            stream.endText();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write text", e);
        }
    }

    public static void rect(PDPageContentStream stream, float x, float y, float width, float height, Color color) {
        try {
            stream.setNonStrokingColor(color);
            stream.addRect(x, y, width, -height);
            stream.fill();
            stream.closePath();
            stream.setNonStrokingColor(Color.BLACK);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to draw rectangle", e);
        }
    }

    public static void rectFontMetrics(PDPageContentStream stream, float x, float y, PDFont font, float fontSize) {
        PDStreamUtils.rect(stream, x, y, 3.0f, FontUtils.getHeight(font, fontSize), Color.BLUE);
        PDStreamUtils.rect(stream, x + 3.0f, y, 3.0f, FontUtils.getAscent(font, fontSize), Color.CYAN);
        PDStreamUtils.rect(stream, x + 3.0f, y - FontUtils.getHeight(font, fontSize), 3.0f, FontUtils.getDescent(font, 14.0f), Color.GREEN);
    }
}

