/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontUtils.class);
    private static final Map<String, FontMetrics> fontMetrics = new HashMap<String, FontMetrics>();

    private FontUtils() {
    }

    public static final PDType0Font loadFont(PDDocument document, String fontPath) throws IOException {
        return PDType0Font.load((PDDocument)document, (InputStream)FontUtils.class.getClassLoader().getResourceAsStream(fontPath));
    }

    public static float getStringWidth(PDFont font, String text, float fontSize) {
        try {
            return font.getStringWidth(text) / 1000.0f * fontSize;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to determine text width", e);
        }
    }

    public static float getAscent(PDFont font, float fontSize) {
        String fontName = font.getName();
        if (!fontMetrics.containsKey(fontName)) {
            try {
                FontUtils.createFontMetrics(font);
            }
            catch (IOException e) {
                LOGGER.info("Getting font ascent distance ...");
                return font.getFontDescriptor().getAscent() / 1000.0f * fontSize;
            }
        }
        return fontMetrics.get(fontName).ascent * fontSize;
    }

    public static float getDescent(PDFont font, float fontSize) {
        String fontName = font.getName();
        if (!fontMetrics.containsKey(fontName)) {
            try {
                FontUtils.createFontMetrics(font);
            }
            catch (IOException e) {
                LOGGER.info("Getting font descent distance ...");
                return font.getFontDescriptor().getDescent() / 1000.0f * fontSize;
            }
        }
        return fontMetrics.get(fontName).descent * fontSize;
    }

    public static float getHeight(PDFont font, float fontSize) {
        String fontName = font.getName();
        if (!fontMetrics.containsKey(fontName)) {
            try {
                FontUtils.createFontMetrics(font);
            }
            catch (IOException e) {
                LOGGER.info("Getting font height ...");
                return font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * fontSize * 0.865f;
            }
        }
        return fontMetrics.get(fontName).height * fontSize;
    }

    private static void createFontMetrics(PDFont font) throws IOException {
        float base = font.getHeight("a".codePointAt(0)) / 1000.0f;
        float ascent = font.getHeight("d".codePointAt(0)) / 1000.0f - base;
        float descent = font.getHeight("g".codePointAt(0)) / 1000.0f - base;
        fontMetrics.put(font.getName(), new FontMetrics(base + ascent + descent, ascent, -descent));
    }

    private static final class FontMetrics {
        private final float ascent;
        private final float descent;
        private final float height;

        public FontMetrics(float height, float ascent, float descent) {
            this.height = height;
            this.ascent = ascent;
            this.descent = descent;
        }
    }
}

